/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumItems;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockDate
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    private static final AxisAlignedBB STEM = new AxisAlignedBB(0.4125, 0.625, 0.4125, 0.6, 1.0, 0.6);
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.3125, 0.125, 0.3125, 0.6875, 1.0, 0.6875);

    public BlockDate() {
        super(Material.field_151585_k);
        this.func_149711_c(0.35f);
        this.func_149675_a(true);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        if ((Integer)state.func_177229_b((IProperty)AGE) != 3) {
            this.field_149782_v = 0.25f;
        }
        return super.func_176195_g(state, world, pos);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((Integer)state.func_177229_b((IProperty)AGE)) {
            case 0: {
                return STEM;
            }
        }
        return BOUNDING_BOX;
    }

    public void func_180650_b(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (!world.func_175697_a(pos, 1)) {
                return;
            }
            if ((Integer)state.func_177229_b((IProperty)AGE) != 7 && ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (world.field_73012_v.nextDouble() <= (double)0.12f ? 1 : 0) != 0)) {
                world.func_180501_a(pos, state.func_177231_a((IProperty)AGE), 2);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == this) {
            IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
            return stateUp.func_177230_c().isLeaves(stateUp, (IBlockAccess)world, pos.func_177984_a());
        }
        return this.func_185514_i(world.func_180495_p(pos.func_177977_b()));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 7) {
            this.func_176226_b(world, pos, state, 0);
            return world.func_175656_a(pos, this.func_176223_P());
        }
        return false;
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if ((Integer)state.func_177229_b((IProperty)AGE) == 7) {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return AtumItems.DATE;
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(4) + 1;
    }

    @Nonnull
    public ItemStack getPickBlock(@Nonnull IBlockState state, RayTraceResult target, @Nonnull World world, @Nonnull BlockPos pos, EntityPlayer player) {
        return new ItemStack(AtumItems.DATE);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) != 7;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return true;
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        int maxAge;
        int growth = (Integer)state.func_177229_b((IProperty)AGE) + MathHelper.func_76136_a((Random)rand, (int)1, (int)2);
        if (growth > (maxAge = 7)) {
            growth = maxAge;
        }
        if ((Integer)state.func_177229_b((IProperty)AGE) != 7) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(growth)), 2);
        }
    }
}

