/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.vegetation;

import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockVine;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOphidianTongue
extends BlockVine
implements IOreDictEntry {
    public static final PropertyBool HAS_FLOWERS = PropertyBool.func_177716_a((String)"flowers");

    public BlockOphidianTongue() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176277_a, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176273_b, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176278_M, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176279_N, (Comparable)Boolean.FALSE).func_177226_a((IProperty)field_176280_O, (Comparable)Boolean.FALSE).func_177226_a((IProperty)HAS_FLOWERS, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185850_c);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)HAS_FLOWERS)).booleanValue() && entity instanceof EntityLivingBase) {
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            livingBase.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 35));
        }
    }

    public void func_180650_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)HAS_FLOWERS)).booleanValue() && rand.nextDouble() <= 0.03) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)HAS_FLOWERS, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public boolean func_193395_a(World world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return this.isAcceptableNeighbor(world, pos.func_177972_a(facing.func_176734_d()), facing) && (block == Blocks.field_150350_a || block == this || this.isAcceptableNeighbor(world, pos.func_177984_a(), EnumFacing.UP));
    }

    private boolean isAcceptableNeighbor(World world, BlockPos pos, EnumFacing facing) {
        IBlockState state = world.func_180495_p(pos);
        return state.func_193401_d((IBlockAccess)world, pos, facing) == BlockFaceShape.SOLID && !BlockOphidianTongue.func_193397_e((Block)state.func_177230_c());
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity tileEntity, @Nonnull ItemStack stack) {
        if (!world.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            player.func_71029_a(Objects.requireNonNull(StatList.func_188055_a((Block)this)));
            BlockOphidianTongue.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(AtumBlocks.OPHIDIAN_TONGUE, 1, 0));
        } else {
            super.func_180657_a(world, player, pos, state, tileEntity, stack);
        }
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)HAS_FLOWERS) != false ? AtumItems.OPHIDIAN_TONGUE_FLOWER : super.func_180660_a(state, rand, fortune);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        EnumFacing facing = EnumFacing.func_176731_b((int)(meta & 0x11B));
        return state.func_177226_a((IProperty)field_176279_N, (Comparable)Boolean.valueOf(facing == EnumFacing.SOUTH)).func_177226_a((IProperty)field_176280_O, (Comparable)Boolean.valueOf(facing == EnumFacing.WEST)).func_177226_a((IProperty)field_176273_b, (Comparable)Boolean.valueOf(facing == EnumFacing.NORTH)).func_177226_a((IProperty)field_176278_M, (Comparable)Boolean.valueOf(facing == EnumFacing.EAST)).func_177226_a((IProperty)HAS_FLOWERS, (Comparable)Boolean.valueOf((meta & 0xF) >> 2 == 1));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)field_176279_N)).booleanValue()) {
            meta |= EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176280_O)).booleanValue()) {
            meta |= EnumFacing.WEST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176273_b)).booleanValue()) {
            meta |= EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176278_M)).booleanValue()) {
            meta |= EnumFacing.EAST.func_176736_b();
        }
        return meta |= (Boolean)state.func_177229_b((IProperty)HAS_FLOWERS) != false ? 4 : 0;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176277_a, field_176273_b, field_176278_M, field_176279_N, field_176280_O, HAS_FLOWERS});
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add((Block)this, "vine");
    }
}

