/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockAtumPlank
extends Block
implements IOreDictEntry {
    private static final Map<WoodType, Block> PLANKS = Maps.newEnumMap(WoodType.class);
    private static final Map<WoodType, Item> STICKS = Maps.newEnumMap(WoodType.class);

    public BlockAtumPlank() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
    }

    public static void registerPlanks() {
        for (WoodType type : WoodType.values()) {
            BlockAtumPlank plank = new BlockAtumPlank();
            PLANKS.put(type, plank);
            AtumRegistry.registerBlock(plank, type.func_176610_l() + "_planks");
        }
    }

    public static Block getPlank(WoodType type) {
        return PLANKS.get((Object)type);
    }

    public static void registerSticks() {
        for (WoodType type : WoodType.values()) {
            Item stick = new Item();
            STICKS.put(type, stick);
            AtumRegistry.registerItem(stick, type.func_176610_l() + "Stick");
            OreDictHelper.add(stick, "stickWood");
        }
    }

    public static Item getStick(WoodType type) {
        return STICKS.get((Object)type);
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess blockAccess, BlockPos blockPos) {
        return WoodType.byIndex(WoodType.values().length).getMapColor();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add(this, "plank", Objects.requireNonNull(this.getRegistryName()).func_110623_a().replace("_planks", ""));
        OreDictHelper.add(this, "plankWood");
    }

    public static enum WoodType implements IStringSerializable
    {
        PALM("palm", MapColor.field_151663_o),
        DEADWOOD("deadwood", MapColor.field_151663_o);

        private static final WoodType[] ORDINAL_LOOKUP;
        private final String unlocalizedName;
        private final MapColor mapColor;

        private WoodType(String unlocalizedName, MapColor mapColor) {
            this.unlocalizedName = unlocalizedName;
            this.mapColor = mapColor;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public String toString() {
            return this.unlocalizedName;
        }

        @Nonnull
        public String func_176610_l() {
            return this.unlocalizedName;
        }

        public static WoodType byIndex(int length) {
            if (length < 0 || length >= ORDINAL_LOOKUP.length) {
                length = 0;
            }
            return ORDINAL_LOOKUP[length];
        }

        static {
            ORDINAL_LOOKUP = new WoodType[WoodType.values().length];
            WoodType[] woodTypeArray = WoodType.values();
            int n = woodTypeArray.length;
            for (int i = 0; i < n; ++i) {
                WoodType type;
                WoodType.ORDINAL_LOOKUP[type.ordinal()] = type = woodTypeArray[i];
            }
        }
    }
}

