/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.blocks.base.IRenderMapper;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import com.teammetallurgy.atum.world.gen.feature.WorldGenPalm;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BlockAtumSapling
extends BlockBush
implements IGrowable,
IRenderMapper,
IOreDictEntry {
    private static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)1);
    private static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.4125, 0.0, 0.4125, 0.6, 0.5, 0.6);
    private static final Map<BlockAtumPlank.WoodType, Block> SAPLINGS = Maps.newEnumMap(BlockAtumPlank.WoodType.class);

    private BlockAtumSapling() {
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
    }

    public static void registerSaplings() {
        for (BlockAtumPlank.WoodType type : BlockAtumPlank.WoodType.values()) {
            if (type == BlockAtumPlank.WoodType.DEADWOOD) continue;
            BlockAtumSapling sapling = new BlockAtumSapling();
            SAPLINGS.put(type, (Block)sapling);
            AtumRegistry.registerBlock((Block)sapling, type.func_176610_l() + "_sapling");
        }
    }

    public static Block getSapling(BlockAtumPlank.WoodType type) {
        return SAPLINGS.get((Object)type);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == AtumBlocks.FERTILE_SOIL || state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            super.func_180650_b(world, pos, state, rand);
            if (!world.func_175697_a(pos, 1)) {
                return;
            }
            if (world.func_175671_l(pos.func_177984_a()) >= 9 && rand.nextInt(20) == 0) {
                this.grow(world, pos, state, rand);
            }
        }
    }

    private void grow(World world, BlockPos pos, IBlockState state, Random random) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            world.func_180501_a(pos, state.func_177231_a((IProperty)STAGE), 4);
        } else {
            this.generateTree(world, pos, state, random);
        }
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        Block blockDown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return blockDown == AtumBlocks.FERTILE_SOIL || blockDown == Blocks.field_150349_c || blockDown == Blocks.field_150346_d;
    }

    public void generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!TerrainGen.saplingGrowTree((World)world, (Random)rand, (BlockPos)pos)) {
            return;
        }
        Object generator = rand.nextInt(10) == 0 ? new WorldGenBigTree(true) : new WorldGenTrees(true);
        int i = 0;
        int j = 0;
        boolean flag = false;
        switch (BlockAtumPlank.WoodType.byIndex(BlockAtumPlank.WoodType.values().length)) {
            case PALM: {
                generator = new WorldGenPalm(true);
                break;
            }
        }
        IBlockState stateAir = Blocks.field_150350_a.func_176223_P();
        if (flag) {
            world.func_180501_a(pos.func_177982_a(i, 0, j), stateAir, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j), stateAir, 4);
            world.func_180501_a(pos.func_177982_a(i, 0, j + 1), stateAir, 4);
            world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), stateAir, 4);
        } else {
            world.func_180501_a(pos, stateAir, 4);
        }
        if (!generator.func_180709_b(world, rand, pos.func_177982_a(i, 0, j))) {
            if (flag) {
                world.func_180501_a(pos.func_177982_a(i, 0, j), state, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j), state, 4);
                world.func_180501_a(pos.func_177982_a(i, 0, j + 1), state, 4);
                world.func_180501_a(pos.func_177982_a(i + 1, 0, j + 1), state, 4);
            } else {
                world.func_180501_a(pos, state, 4);
            }
        }
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{STAGE};
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        return (double)world.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(@Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.grow(world, pos, state, rand);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf((meta & 8) >> 3));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        return i |= (Integer)state.func_177229_b((IProperty)STAGE) << 3;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add((Block)this, "treeSapling");
    }
}

