/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.blocks.wood;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.blocks.wood.tileentity.crate.TileEntityCrate;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.IOreDictEntry;
import com.teammetallurgy.atum.utils.OreDictHelper;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrate
extends BlockContainer
implements IOreDictEntry {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final Map<BlockAtumPlank.WoodType, BlockCrate> CRATES = Maps.newEnumMap(BlockAtumPlank.WoodType.class);

    private BlockCrate() {
        super(Material.field_151575_d);
        this.func_149711_c(3.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public static void registerCrates() {
        for (BlockAtumPlank.WoodType type : BlockAtumPlank.WoodType.values()) {
            BlockCrate crate = new BlockCrate();
            CRATES.put(type, crate);
            AtumRegistry.registerBlock((Block)crate, type.func_176610_l() + "_crate");
        }
    }

    public static BlockCrate getCrate(BlockAtumPlank.WoodType type) {
        return CRATES.get((Object)type);
    }

    public TileEntity func_149915_a(@Nonnull World world, int meta) {
        return new TileEntityCrate();
    }

    @Nonnull
    public MapColor func_180659_g(IBlockState state, IBlockAccess blockAccess, BlockPos blockPos) {
        return BlockAtumPlank.WoodType.byIndex(BlockAtumPlank.WoodType.values().length).getMapColor();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCrate) {
            player.openGui((Object)Atum.instance, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            return true;
        }
        return false;
    }

    @Nonnull
    public IBlockState getStateForPlacement(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @Nonnull EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tileEntity;
        boolean isEast;
        EnumFacing facing = EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d();
        state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        BlockPos posNorth = pos.func_177978_c();
        BlockPos posSouth = pos.func_177968_d();
        BlockPos posWest = pos.func_177976_e();
        BlockPos posEast = pos.func_177974_f();
        boolean isNorth = this == world.func_180495_p(posNorth).func_177230_c();
        boolean isSouth = this == world.func_180495_p(posSouth).func_177230_c();
        boolean isWest = this == world.func_180495_p(posWest).func_177230_c();
        boolean bl = isEast = this == world.func_180495_p(posEast).func_177230_c();
        if (!(isNorth || isSouth || isWest || isEast)) {
            world.func_180501_a(pos, state, 3);
        } else if (facing.func_176740_k() != EnumFacing.Axis.X || !isNorth && !isSouth) {
            if (facing.func_176740_k() == EnumFacing.Axis.Z && (isWest || isEast)) {
                if (isWest) {
                    world.func_180501_a(posWest, state, 3);
                } else {
                    world.func_180501_a(posEast, state, 3);
                }
                world.func_180501_a(pos, state, 3);
            }
        } else {
            if (isNorth) {
                world.func_180501_a(posNorth, state, 3);
            } else {
                world.func_180501_a(posSouth, state, 3);
            }
            world.func_180501_a(pos, state, 3);
        }
        if (stack.func_82837_s() && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityCrate) {
            ((TileEntityCrate)tileEntity).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCrate) {
            tileEntity.func_145836_u();
        }
    }

    public void func_180663_b(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityCrate) {
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180657_a(@Nonnull World world, EntityPlayer player, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nullable TileEntity tileEntity, @Nonnull ItemStack stack) {
        if (tileEntity instanceof TileEntityCrate) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityCrate)tileEntity));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180657_a(world, player, pos, state, tileEntity, stack);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)((TileEntityCrate)world.func_175625_s(pos)));
    }

    public IBlockState correctFacing(World world, BlockPos pos, IBlockState state) {
        EnumFacing facingCheck = null;
        for (EnumFacing horizontal : EnumFacing.Plane.HORIZONTAL) {
            IBlockState stateHorizontal = world.func_180495_p(pos.func_177972_a(horizontal));
            if (stateHorizontal.func_177230_c() == this) {
                return state;
            }
            if (!stateHorizontal.func_185913_b()) continue;
            if (facingCheck != null) {
                facingCheck = null;
                break;
            }
            facingCheck = horizontal;
        }
        if (facingCheck != null) {
            return state.func_177226_a((IProperty)FACING, (Comparable)facingCheck.func_176734_d());
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (world.func_180495_p(pos.func_177972_a(facing)).func_185913_b()) {
            facing = facing.func_176734_d();
        }
        if (world.func_180495_p(pos.func_177972_a(facing)).func_185913_b()) {
            facing = facing.func_176746_e();
        }
        if (world.func_180495_p(pos.func_177972_a(facing)).func_185913_b()) {
            facing = facing.func_176734_d();
        }
        return state.func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public void getOreDictEntries() {
        OreDictHelper.add((Block)this, "crate");
        OreDictHelper.add((Block)this, "chest");
        OreDictHelper.add((Block)this, "chestWood");
    }
}

