/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.client.model.entity.ModelCamel;
import com.teammetallurgy.atum.client.render.entity.layer.LayerCamelArmor;
import com.teammetallurgy.atum.client.render.entity.layer.LayerCamelCarpet;
import com.teammetallurgy.atum.entity.animal.EntityCamel;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCamel
extends RenderLiving<EntityCamel> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();

    public RenderCamel(RenderManager renderManager) {
        super(renderManager, (ModelBase)new ModelCamel(0.0f), 0.7f);
        this.func_177094_a(new LayerCamelArmor(this));
        this.func_177094_a(new LayerCamelCarpet(this));
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityCamel camel) {
        String name;
        String texture = camel.getTexture();
        ResourceLocation location = CACHE.get(texture);
        if (camel.func_145818_k_() && (name = camel.func_95999_t()).equalsIgnoreCase("girafi")) {
            location = this.getCamelTexture("girafi");
        }
        if (location == null) {
            location = new ResourceLocation(texture);
            CACHE.put(texture, location);
        }
        return location;
    }

    private ResourceLocation getCamelTexture(String fileName) {
        return new ResourceLocation("atum", "textures/entity/camel_" + fileName + ".png");
    }
}

