/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.teammetallurgy.atum.client.render.entity.layer.LayerDesertWolfCollar;
import com.teammetallurgy.atum.client.render.entity.layer.LayerWolfSaddle;
import com.teammetallurgy.atum.entity.animal.EntityDesertWolf;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDesertWolf
extends RenderLiving<EntityDesertWolf> {
    private static final ResourceLocation TAMED_DESERT_WOLF_TEXTURES = new ResourceLocation("atum", "textures/entity/desert_wolf_tame.png");
    private static final ResourceLocation ANGRY_DESERT_WOLF_TEXTURES = new ResourceLocation("atum", "textures/entity/desert_wolf_angry.png");

    public RenderDesertWolf(RenderManager renderManager, ModelBase modelBase, float shadowSize) {
        super(renderManager, modelBase, shadowSize);
        this.func_177094_a(new LayerWolfSaddle(this));
        this.func_177094_a(new LayerDesertWolfCollar(this));
    }

    protected float handleRotationFloat(EntityDesertWolf desertWolf, float rotation) {
        return desertWolf.getTailRotation();
    }

    public void doRender(@Nonnull EntityDesertWolf desertWolf, double x, double y, double z, float entityYaw, float partialTicks) {
        if (desertWolf.isWolfWet()) {
            GlStateManager.func_179094_E();
            float f = desertWolf.func_70013_c() * desertWolf.getShadingWhileWet(partialTicks);
            GlStateManager.func_179124_c((float)f, (float)f, (float)f);
            GlStateManager.func_179121_F();
        }
        super.func_76986_a((EntityLiving)desertWolf, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityDesertWolf desertWolf) {
        ItemStack wolfArmor = desertWolf.getArmor();
        if (desertWolf.func_70909_n()) {
            if (desertWolf.isArmor(wolfArmor)) {
                EntityDesertWolf.ArmorType armorType = EntityDesertWolf.ArmorType.getByItemStack(wolfArmor);
                Minecraft.func_71410_x().func_110434_K().func_110579_a(TAMED_DESERT_WOLF_TEXTURES, (ITextureObject)new LayeredTexture(new String[]{armorType.getTextureName()}));
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110579_a(TAMED_DESERT_WOLF_TEXTURES, (ITextureObject)new LayeredTexture(new String[]{TAMED_DESERT_WOLF_TEXTURES.toString()}));
            }
            return TAMED_DESERT_WOLF_TEXTURES;
        }
        return ANGRY_DESERT_WOLF_TEXTURES;
    }

    protected void preRenderCallback(EntityDesertWolf desertWolf, float partialTickTime) {
        if (desertWolf.isAlpha()) {
            float scale = 1.5f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        }
    }
}

