/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.entity.stone.EntityStoneguard;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderStoneguard
extends RenderBiped<EntityStoneguard> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();

    public RenderStoneguard(RenderManager renderManager) {
        super(renderManager, (ModelBiped)new ModelPlayer(0.0f, false), 0.5f);
        LayerBipedArmor armor = new LayerBipedArmor((RenderLivingBase)this){

            protected void func_177177_a() {
                this.field_177189_c = new ModelBiped(0.5f);
                this.field_177186_d = new ModelBiped(1.0f);
            }
        };
        this.func_177094_a((LayerRenderer)armor);
    }

    @Nullable
    protected ResourceLocation getEntityTexture(@Nonnull EntityStoneguard stoneguard) {
        if (stoneguard.func_145818_k_() && (stoneguard.func_95999_t().equalsIgnoreCase("iron") || stoneguard.func_95999_t().equalsIgnoreCase("nutz"))) {
            return new ResourceLocation("atum", "textures/entity/stoneguard_derp.png");
        }
        String entityName = Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(stoneguard.getClass())).getRegistryName()).func_110623_a();
        String texture = new ResourceLocation("atum", "textures/entity/" + entityName + "_" + stoneguard.getVariant()) + ".png";
        ResourceLocation location = CACHE.get(texture);
        if (location == null) {
            location = new ResourceLocation(texture);
            CACHE.put(texture, location);
        }
        return location;
    }
}

