/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.client.render.entity.mobs;

import com.google.common.collect.Maps;
import com.teammetallurgy.atum.client.model.entity.ModelStonewarden;
import com.teammetallurgy.atum.entity.stone.EntityStonewarden;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderStonewarden
extends RenderLiving<EntityStonewarden> {
    private static final Map<String, ResourceLocation> CACHE = Maps.newHashMap();

    public RenderStonewarden(RenderManager manager) {
        super(manager, (ModelBase)new ModelStonewarden(), 0.5f);
    }

    protected void applyRotations(EntityStonewarden stonewarden, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_77043_a((EntityLivingBase)stonewarden, ageInTicks, rotationYaw, partialTicks);
        if ((double)stonewarden.field_70721_aZ >= 0.01) {
            float swingValue = stonewarden.field_184619_aG - stonewarden.field_70721_aZ * (1.0f - partialTicks) + 6.0f;
            float swing = (Math.abs(swingValue % 13.0f - 6.5f) - 3.25f) / 3.25f;
            GlStateManager.func_179114_b((float)(6.5f * swing), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntityStonewarden stonewarden) {
        String entityName = Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(stonewarden.getClass())).getRegistryName()).func_110623_a();
        String texture = String.valueOf(new ResourceLocation("atum", "textures/entity/" + entityName + "_" + stonewarden.getVariant()) + ".png");
        ResourceLocation location = CACHE.get(texture);
        if (location == null) {
            location = new ResourceLocation(texture);
            CACHE.put(texture, location);
        }
        return location;
    }
}

