/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.blocks.linen.BlockLinenCarpet;
import com.teammetallurgy.atum.blocks.wood.BlockCrate;
import com.teammetallurgy.atum.entity.ai.AICamelCaravan;
import com.teammetallurgy.atum.entity.animal.EntityDesertWolf;
import com.teammetallurgy.atum.entity.projectile.EntityCamelSpit;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.biome.BiomeDeadOasis;
import com.teammetallurgy.atum.world.biome.BiomeOasis;
import com.teammetallurgy.atum.world.biome.BiomeSandDunes;
import com.teammetallurgy.atum.world.biome.BiomeSandPlains;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EntityCamel
extends AbstractHorse
implements IRangedAttackMob {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityCamel.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_COLOR_ID = EntityDataManager.func_187226_a(EntityCamel.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> LEFT_CRATE = EntityDataManager.func_187226_a(EntityCamel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> RIGHT_CRATE = EntityDataManager.func_187226_a(EntityCamel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final DataParameter<ItemStack> ARMOR_STACK = EntityDataManager.func_187226_a(EntityCamel.class, (DataSerializer)DataSerializers.field_187196_f);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("13a48eeb-c17d-45cc-8163-e7210a6adfc9");
    public static final float CAMEL_RIDING_SPEED_AMOUNT = 0.65f;
    private String texturePath;
    private boolean didSpit;
    private EntityCamel caravanHead;
    private EntityCamel caravanTail;
    private IItemHandler itemHandler = null;

    public EntityCamel(World world) {
        super(world);
        this.field_70728_aV = 3;
        this.func_70105_a(0.9f, 1.87f);
        this.field_190688_bE = false;
        this.field_70138_W = 1.6f;
        this.func_110226_cD();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLOR_ID, (Object)-1);
        if (this.hasSkinVariants()) {
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }
        this.field_70180_af.func_187214_a(LEFT_CRATE, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(RIGHT_CRATE, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(ARMOR_STACK, (Object)ItemStack.field_190927_a);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getCamelMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(36.0);
        this.func_110148_a(field_110271_bv).func_111128_a(0.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.hasSkinVariants()) {
            int variant = this.getCamelVariantBiome();
            this.setVariant(variant);
        }
        return livingdata;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRunAroundLikeCrazy((AbstractHorse)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AICamelCaravan(this, 2.1f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.25, 40, 20.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIDefendTarget(this));
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191260_dz;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_191254_dE;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191252_dC;
    }

    protected void func_180429_a(@Nonnull BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187729_cv, 0.15f, 1.0f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected SoundEvent func_184785_dv() {
        return SoundEvents.field_191260_dz;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AtumLootTables.CAMEL;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        return otherAnimal != this && otherAnimal instanceof EntityCamel && this.func_110200_cJ() && ((EntityCamel)otherAnimal).func_110200_cJ();
    }

    public EntityCamel createChild(@Nonnull EntityAgeable ageable) {
        EntityCamel camel = new EntityCamel(this.field_70170_p);
        camel.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)ageable)), null);
        return camel;
    }

    private float getCamelMaxHealth() {
        if (this.func_110248_bS()) {
            return 40.0f;
        }
        return 20.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    private boolean hasSkinVariants() {
        return true;
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    private int getCamelVariantBiome() {
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        int chance = this.field_70146_Z.nextInt(100);
        if (this.field_70170_p.field_73011_w.getDimension() == AtumConfig.DIMENSION_ID) {
            if (biome instanceof BiomeSandPlains) {
                return chance <= 50 ? 0 : 5;
            }
            if (biome instanceof BiomeSandDunes) {
                return chance <= 50 ? 0 : 2;
            }
            if (biome instanceof BiomeOasis) {
                return chance <= 50 ? 0 : 1;
            }
            if (biome instanceof BiomeDeadOasis) {
                return chance <= 50 ? 3 : 4;
            }
            return 0;
        }
        return MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)5);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        String entityName = Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(((Object)((Object)this)).getClass())).getRegistryName()).func_110623_a();
        if (this.hasSkinVariants()) {
            if (this.texturePath == null) {
                this.texturePath = new ResourceLocation("atum", "textures/entity/" + entityName + "_" + this.getVariant()) + ".png";
            }
        } else {
            this.texturePath = String.valueOf(new ResourceLocation("atum", "textures/entity/" + entityName + ".png"));
        }
        return this.texturePath;
    }

    public void func_82196_d(@Nonnull EntityLivingBase target, float distanceFactor) {
        this.spit(target);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    private void spit(EntityLivingBase target) {
        EntityCamelSpit camelSpit = new EntityCamelSpit(this.field_70170_p, this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - camelSpit.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        camelSpit.func_70186_c(d0, d1 + (double)f, d2, 1.5f, 10.0f);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191255_dF, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        this.field_70170_p.func_72838_d((Entity)camelSpit);
        this.didSpit = true;
    }

    private void setDidSpit(boolean didSpit) {
        this.didSpit = didSpit;
    }

    public boolean func_184776_b() {
        return false;
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.78;
    }

    public void func_184232_k(@Nonnull Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float cos = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float sin = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            passenger.func_70107_b(this.field_70165_t + (double)(0.1f * sin), this.field_70163_u + this.func_70042_X() + passenger.func_70033_W(), this.field_70161_v - (double)(0.1f * cos));
        }
    }

    public void func_70659_e(float speed) {
        if (this.func_184207_aI()) {
            super.func_70659_e(speed * 0.65f);
        } else {
            super.func_70659_e(speed);
        }
    }

    public void leaveCaravan() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityCamel camel) {
        this.caravanHead = camel;
        this.caravanHead.caravanTail = this;
    }

    public boolean hasCaravanTrail() {
        return this.caravanTail != null;
    }

    public boolean inCaravan() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityCamel getCaravanHead() {
        return this.caravanHead;
    }

    protected double func_190634_dg() {
        return 2.0;
    }

    protected void func_190679_dD() {
        if (!this.inCaravan() && this.func_70631_g_()) {
            super.func_190679_dD();
        }
    }

    public boolean func_190684_dE() {
        return false;
    }

    @Nullable
    public EnumDyeColor getColor() {
        int color = (Integer)this.field_70180_af.func_187225_a(DATA_COLOR_ID);
        return color == -1 ? null : EnumDyeColor.func_176764_b((int)color);
    }

    private void setColor(@Nullable EnumDyeColor color) {
        this.field_70180_af.func_187227_b(DATA_COLOR_ID, (Object)(color == null ? -1 : color.func_176765_a()));
    }

    public boolean hasColor() {
        return this.getColor() != null;
    }

    protected void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_110232_cE();
            this.setColorByItem(this.field_110296_bG.func_70301_a(2));
        }
        this.setArmorStack(this.field_110296_bG.func_70301_a(1));
        this.field_70180_af.func_187227_b(LEFT_CRATE, (Object)this.field_110296_bG.func_70301_a(3));
        this.field_70180_af.func_187227_b(RIGHT_CRATE, (Object)this.field_110296_bG.func_70301_a(4));
    }

    private void setArmorStack(@Nonnull ItemStack stack) {
        ArmorType armorType = ArmorType.getByItemStack(stack);
        this.field_70180_af.func_187227_b(ARMOR_STACK, (Object)stack);
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_188479_b(ARMOR_MODIFIER_UUID);
            int protection = armorType.getProtection();
            if (protection != 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(new AttributeModifier(ARMOR_MODIFIER_UUID, "Camel armor bonus", (double)protection, 0).func_111168_a(false));
            }
        }
    }

    @Nonnull
    public ItemStack getArmor() {
        return (ItemStack)this.field_70180_af.func_187225_a(ARMOR_STACK);
    }

    private void setColorByItem(@Nonnull ItemStack stack) {
        if (this.isValidCarpet(stack)) {
            if (stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
                this.setColor(EnumDyeColor.func_176764_b((int)stack.func_77960_j()));
            } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockLinenCarpet) {
                BlockLinenCarpet linenCarpet = (BlockLinenCarpet)Block.func_149634_a((Item)stack.func_77973_b());
                this.setColor(EnumDyeColor.valueOf((String)linenCarpet.getColorString().toUpperCase()));
            }
        } else {
            this.setColor(null);
        }
    }

    public boolean isValidCarpet(@Nonnull ItemStack stack) {
        return stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg) || Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockLinenCarpet;
    }

    public boolean func_190682_f(@Nonnull ItemStack stack) {
        return ArmorType.isArmor(stack);
    }

    public boolean func_190677_dK() {
        return true;
    }

    public void func_110199_f(@Nonnull EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w((Entity)player)) && this.func_110248_bS()) {
            this.field_110296_bG.func_110133_a(this.func_70005_c_());
            player.openGui((Object)Atum.instance, 3, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    public ContainerHorseChest getHorseChest() {
        return this.field_110296_bG;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            compound.func_74782_a("ArmorItem", (NBTBase)this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
        if (!this.field_110296_bG.func_70301_a(2).func_190926_b()) {
            compound.func_74782_a("Carpet", (NBTBase)this.field_110296_bG.func_70301_a(2).func_77955_b(new NBTTagCompound()));
        }
        if (!this.field_110296_bG.func_70301_a(3).func_190926_b()) {
            compound.func_74782_a("CrateLeft", (NBTBase)this.field_110296_bG.func_70301_a(3).func_77955_b(new NBTTagCompound()));
        }
        if (!this.field_110296_bG.func_70301_a(4).func_190926_b()) {
            compound.func_74782_a("CrateRight", (NBTBase)this.field_110296_bG.func_70301_a(4).func_77955_b(new NBTTagCompound()));
        }
        if (this.hasLeftCrate()) {
            NBTTagList tagList = new NBTTagList();
            for (int slot = this.getNonCrateSize(); slot < this.field_110296_bG.func_70302_i_(); ++slot) {
                ItemStack slotStack = this.field_110296_bG.func_70301_a(slot);
                if (slotStack.func_190926_b()) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)slot);
                slotStack.func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a("Items", (NBTBase)tagList);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        ItemStack armorStack;
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getCamelMaxHealth());
        if (compound.func_150297_b("Carpet", 10)) {
            this.field_110296_bG.func_70299_a(2, new ItemStack(compound.func_74775_l("Carpet")));
        }
        if (compound.func_150297_b("ArmorItem", 10) && !(armorStack = new ItemStack(compound.func_74775_l("ArmorItem"))).func_190926_b() && this.func_190682_f(armorStack)) {
            this.field_110296_bG.func_70299_a(1, armorStack);
        }
        if (compound.func_150297_b("CrateLeft", 10)) {
            this.field_110296_bG.func_70299_a(3, new ItemStack(compound.func_74775_l("CrateLeft")));
        }
        if (compound.func_150297_b("CrateRight", 10)) {
            this.field_110296_bG.func_70299_a(4, new ItemStack(compound.func_74775_l("CrateRight")));
        }
        if (this.hasLeftCrate()) {
            NBTTagList tagList = compound.func_150295_c("Items", 10);
            this.func_110226_cD();
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                int slot = tagCompound.func_74771_c("Slot") & 0xFF;
                if (slot < this.getNonCrateSize() || slot >= this.field_110296_bG.func_70302_i_()) continue;
                this.field_110296_bG.func_70299_a(slot, new ItemStack(tagCompound));
            }
        }
        this.func_110232_cE();
    }

    protected void func_110226_cD() {
        ContainerHorseChest caemlInventory = this.field_110296_bG;
        this.field_110296_bG = new ContainerHorseChest("CamelChest", this.func_190686_di());
        this.field_110296_bG.func_110133_a(this.func_70005_c_());
        if (caemlInventory != null) {
            caemlInventory.func_110132_b((IInventoryChangedListener)this);
            int size = Math.min(caemlInventory.func_70302_i_(), this.field_110296_bG.func_70302_i_());
            for (int slot = 0; slot < size; ++slot) {
                ItemStack slotStack = caemlInventory.func_70301_a(slot);
                if (slotStack.func_190926_b()) continue;
                this.field_110296_bG.func_70299_a(slot, slotStack.func_77946_l());
            }
        }
        this.field_110296_bG.func_110134_a((IInventoryChangedListener)this);
        this.func_110232_cE();
        this.itemHandler = new InvWrapper((IInventory)this.field_110296_bG);
    }

    public void func_76316_a(IInventory invBasic) {
        this.func_110232_cE();
    }

    protected int func_190686_di() {
        return this.getNonCrateSize() + 2 * (this.getInventoryColumns() * 3);
    }

    public int getNonCrateSize() {
        return 5;
    }

    public int getInventoryColumns() {
        return 4;
    }

    public boolean hasLeftCrate() {
        return !((ItemStack)this.field_70180_af.func_187225_a(LEFT_CRATE)).func_190926_b();
    }

    public boolean hasRightCrate() {
        return !((ItemStack)this.field_70180_af.func_187225_a(RIGHT_CRATE)).func_190926_b();
    }

    public boolean func_184645_a(EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!heldStack.func_190926_b()) {
            boolean eating = this.func_190678_b(player, heldStack);
            if (!eating && !this.func_110248_bS()) {
                if (heldStack.func_111282_a(player, (EntityLivingBase)this, hand)) {
                    return true;
                }
                this.func_190687_dF();
                return true;
            }
            if (!(eating || this.hasLeftCrate() && this.hasRightCrate() || !(Block.func_149634_a((Item)heldStack.func_77973_b()) instanceof BlockCrate))) {
                this.func_110199_f(player);
                return true;
            }
            if (!eating && this.getArmor().func_190926_b() && this.func_190682_f(heldStack)) {
                this.func_110199_f(player);
                return true;
            }
            if (!eating && this.field_110296_bG.func_70301_a(2).func_190926_b() && this.isValidCarpet(heldStack)) {
                this.func_110199_f(player);
                return true;
            }
            if (!(eating || this.func_70631_g_() || this.func_110257_ck() || heldStack.func_77973_b() != Items.field_151141_av)) {
                this.func_110199_f(player);
                return true;
            }
            if (!eating && heldStack.func_77973_b() == Items.field_151133_ar && !this.func_70631_g_() && this.func_110248_bS()) {
                heldStack.func_190918_g(1);
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                if (heldStack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                    player.func_71019_a(new ItemStack(Items.field_151117_aB), false);
                }
                return true;
            }
            if (eating) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldStack.func_190918_g(1);
                }
                return true;
            }
        }
        if (!this.func_70631_g_()) {
            if (this.func_110248_bS() && player.func_70093_af()) {
                this.func_110199_f(player);
                return true;
            }
            if (this.func_184207_aI()) {
                return super.func_184645_a(player, hand);
            }
        }
        if (this.func_70631_g_()) {
            return super.func_184645_a(player, hand);
        }
        if (heldStack.func_111282_a(player, (EntityLivingBase)this, hand)) {
            return true;
        }
        this.func_110237_h(player);
        return true;
    }

    protected boolean func_190678_b(@Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        boolean isEating = false;
        float healAmount = 0.0f;
        int growthAmount = 0;
        int temperAmount = 0;
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O) {
            healAmount = 2.0f;
            growthAmount = 20;
            temperAmount = 3;
        } else if (item == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
            healAmount = 20.0f;
            growthAmount = 180;
        } else if (item == Items.field_151034_e) {
            healAmount = 3.0f;
            growthAmount = 60;
            temperAmount = 3;
        } else if (item == AtumItems.DATE) {
            healAmount = 3.0f;
            growthAmount = 60;
            temperAmount = 3;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                isEating = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151150_bK) {
            healAmount = 4.0f;
            growthAmount = 60;
            temperAmount = 5;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                isEating = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151153_ao || item == AtumItems.GOLDEN_DATE || item == AtumItems.ENCHANTED_GOLDEN_DATE) {
            healAmount = 10.0f;
            growthAmount = 240;
            temperAmount = 10;
            if (!this.func_110248_bS()) {
                this.func_110263_g(player);
            } else if (this.func_70874_b() == 0 && !this.func_70880_s()) {
                isEating = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && healAmount > 0.0f) {
            this.func_70691_i(healAmount);
            isEating = true;
        }
        if (this.func_70631_g_() && growthAmount > 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(growthAmount);
            }
            isEating = true;
        }
        if (temperAmount > 0 && (isEating || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            isEating = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(temperAmount);
            }
        }
        if (isEating) {
            this.eatingCamel();
        }
        return isEating;
    }

    private void eatingCamel() {
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191253_dD, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    public void func_110234_j(boolean tamed) {
        super.func_110234_j(tamed);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)this.getCamelMaxHealth());
        this.func_70691_i(this.getCamelMaxHealth());
    }

    public float func_180484_a(BlockPos pos) {
        Block blockDown = this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c();
        return blockDown == AtumBlocks.SAND || blockDown == AtumBlocks.FERTILE_SOIL || blockDown == AtumBlocks.LIMESTONE_GRAVEL || blockDown == this.field_175506_bl ? 10.0f : this.field_70170_p.func_175724_o(pos) - 0.5f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70601_bi() {
        int z;
        int y;
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        BlockPos spawnPos = new BlockPos(x, y = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b), z = MathHelper.func_76128_c((double)this.field_70161_v));
        Block spawnBlock = this.field_70170_p.func_180495_p(spawnPos.func_177977_b()).func_177230_c();
        if (spawnBlock != AtumBlocks.SAND && spawnBlock != AtumBlocks.FERTILE_SOIL && spawnBlock != AtumBlocks.LIMESTONE_GRAVEL) {
            if (spawnBlock != this.field_175506_bl) return false;
        }
        if (this.field_70170_p.func_175699_k(spawnPos) <= 8) return false;
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (!(this.func_180484_a(blockPos) >= 0.0f)) return false;
        if (!this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b()).func_189884_a((Entity)this)) return false;
        return true;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public static enum ArmorType {
        NONE(0),
        IRON(5, "iron"),
        GOLD(7, "gold"),
        DIAMOND(11, "diamond");

        private final ResourceLocation textureName;
        private final String typeName;
        private final int protection;

        private ArmorType(int armorStrength) {
            this.protection = armorStrength;
            this.typeName = null;
            this.textureName = null;
        }

        private ArmorType(int armorStrength, String typeName) {
            this.protection = armorStrength;
            this.typeName = typeName;
            this.textureName = new ResourceLocation("atum", "textures/entity/armor/camel_armor_" + typeName + ".png");
        }

        public int getProtection() {
            return this.protection;
        }

        public String getName() {
            return this.typeName;
        }

        public ResourceLocation getTextureName() {
            return this.textureName;
        }

        public static ArmorType getByItemStack(@Nonnull ItemStack stack) {
            Item item = stack.func_77973_b();
            if (item == AtumItems.CAMEL_IRON_ARMOR) {
                return IRON;
            }
            if (item == AtumItems.CAMEL_GOLD_ARMOR) {
                return GOLD;
            }
            if (item == AtumItems.CAMEL_DIAMOND_ARMOR) {
                return DIAMOND;
            }
            return NONE;
        }

        public static boolean isArmor(@Nonnull ItemStack stack) {
            return ArmorType.getByItemStack(stack) != NONE;
        }
    }

    static class AIHurtByTarget
    extends EntityAIHurtByTarget {
        AIHurtByTarget(EntityCamel camel) {
            super((EntityCreature)camel, false, new Class[0]);
        }

        public boolean func_75253_b() {
            EntityCamel camel;
            if (this.field_75299_d instanceof EntityCamel && (camel = (EntityCamel)this.field_75299_d).didSpit) {
                camel.setDidSpit(false);
                return false;
            }
            return super.func_75253_b();
        }
    }

    static class AIDefendTarget
    extends EntityAINearestAttackableTarget<EntityDesertWolf> {
        AIDefendTarget(EntityCamel camel) {
            super((EntityCreature)camel, EntityDesertWolf.class, 16, false, true, null);
        }

        public boolean func_75250_a() {
            if (super.func_75250_a() && this.field_75309_a != null && !((EntityDesertWolf)this.field_75309_a).func_70909_n()) {
                return true;
            }
            this.field_75299_d.func_70624_b(null);
            return false;
        }

        protected double func_111175_f() {
            return super.func_111175_f() * 0.25;
        }
    }
}

