/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.animal;

import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestone;
import com.teammetallurgy.atum.blocks.wood.BlockDeadwood;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumLootTables;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityScarab
extends EntityMob {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityScarab.class, (DataSerializer)DataSerializers.field_187192_b);
    private String texturePath;

    public EntityScarab(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.3f);
    }

    protected int func_70693_a(EntityPlayer player) {
        if (this.getVariant() == 1) {
            return 30;
        }
        return 3;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIHideInBlock(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        if (this.getVariant() == 1) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (this.field_70170_p.field_73012_v.nextDouble() <= 0.002) {
            this.setVariant(1);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
            this.func_70691_i(16.0f);
        } else {
            this.setVariant(0);
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        }
        return livingdata;
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        String entityName = Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(((Object)((Object)this)).getClass())).getRegistryName()).func_110623_a();
        if (this.texturePath == null) {
            this.texturePath = this.getVariant() == 1 ? String.valueOf(new ResourceLocation("atum", "textures/entity/" + entityName + "_golden") + ".png") : String.valueOf(new ResourceLocation("atum", "textures/entity/" + entityName) + ".png");
        }
        return this.texturePath;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187535_aY;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187590_ba;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187536_aZ;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187592_bb, 0.15f, 1.0f);
    }

    protected ResourceLocation func_184647_J() {
        if (this.getVariant() == 1) {
            return AtumLootTables.SCARAB_GOLDEN;
        }
        return AtumLootTables.SCARAB;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    public float func_180484_a(@Nonnull BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == AtumBlocks.LIMESTONE ? 10.0f : super.func_180484_a(pos);
    }

    public float func_70047_e() {
        return 0.1f;
    }

    public double func_70033_W() {
        return 0.1;
    }

    protected boolean func_70814_o() {
        return true;
    }

    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 5.0);
            return player == null;
        }
        return false;
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
    }

    static class AIHideInBlock
    extends EntityAIWander {
        private EnumFacing facing;
        private boolean doMerge;

        AIHideInBlock(EntityScarab scarab) {
            super((EntityCreature)scarab, 1.0, 10);
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (this.field_75457_a.func_70638_az() != null) {
                return false;
            }
            if (!this.field_75457_a.func_70661_as().func_75500_f()) {
                return false;
            }
            Random random = this.field_75457_a.func_70681_au();
            if (ForgeEventFactory.getMobGriefingEvent((World)this.field_75457_a.field_70170_p, (Entity)this.field_75457_a) && random.nextInt(10) == 0) {
                this.facing = EnumFacing.func_176741_a((Random)random);
                BlockPos pos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.facing);
                IBlockState state = this.field_75457_a.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() == AtumBlocks.LIMESTONE || state.func_177230_c() == AtumBlocks.DEADWOOD_LOG) {
                    this.doMerge = true;
                    return true;
                }
            }
            this.doMerge = false;
            return super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.doMerge && super.func_75253_b();
        }

        public void func_75249_e() {
            if (!this.doMerge) {
                super.func_75249_e();
            } else {
                World world = this.field_75457_a.field_70170_p;
                BlockPos pos = new BlockPos(this.field_75457_a.field_70165_t, this.field_75457_a.field_70163_u + 0.5, this.field_75457_a.field_70161_v).func_177972_a(this.facing);
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() == AtumBlocks.LIMESTONE) {
                    world.func_180501_a(pos, AtumBlocks.LIMESTONE.func_176223_P().func_177226_a((IProperty)BlockLimestone.HAS_SCARAB, (Comparable)Boolean.valueOf(true)), 3);
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
                if (state.func_177230_c() == AtumBlocks.DEADWOOD_LOG) {
                    world.func_180501_a(pos, AtumBlocks.DEADWOOD_LOG.func_176223_P().func_177226_a((IProperty)BlockDeadwood.HAS_SCARAB, (Comparable)Boolean.valueOf(true)), 3);
                    this.field_75457_a.func_70656_aK();
                    this.field_75457_a.func_70106_y();
                }
            }
        }
    }
}

