/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.bandit;

import com.teammetallurgy.atum.entity.animal.EntityDesertWolf;
import com.teammetallurgy.atum.entity.stone.EntityStoneBase;
import com.teammetallurgy.atum.entity.undead.EntityUndeadBase;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityBanditBase
extends EntityMob {
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityBanditBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private String texturePath;

    EntityBanditBase(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        new PathNavigateGround((EntityLiving)this, world).func_179691_c(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityDesertWolf.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[]{EntityBanditBase.class}));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityUndeadBase.class, true));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityStoneBase.class, true));
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return !EntityBanditBase.class.isAssignableFrom(cls) && super.func_70686_a(cls);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        if (this.hasSkinVariants()) {
            this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        }
    }

    @Nonnull
    protected PathNavigate func_175447_b(@Nonnull World world) {
        return new PathNavigateGround((EntityLiving)this, world);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.func_180483_b(difficulty);
        this.func_180481_a(difficulty);
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * difficulty.func_180170_c());
        if (this.hasSkinVariants()) {
            int variant = MathHelper.func_76136_a((Random)this.field_70170_p.field_73012_v, (int)0, (int)this.getVariantAmount());
            this.setVariant(variant);
        }
        return livingdata;
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
    }

    protected int getVariantAmount() {
        return 6;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70180_af.func_187223_a()) {
            this.field_70180_af.func_187230_e();
            this.texturePath = null;
        }
    }

    protected boolean hasSkinVariants() {
        return true;
    }

    private void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
        this.texturePath = null;
    }

    private int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    @SideOnly(value=Side.CLIENT)
    public String getTexture() {
        String entityName = Objects.requireNonNull(Objects.requireNonNull(EntityRegistry.getEntry(((Object)((Object)this)).getClass())).getRegistryName()).func_110623_a();
        if (this.hasSkinVariants()) {
            if (this.texturePath == null) {
                this.texturePath = new ResourceLocation("atum", "textures/entity/" + entityName + "_" + this.getVariant()) + ".png";
            }
        } else {
            this.texturePath = String.valueOf(new ResourceLocation("atum", "textures/entity/" + entityName + ".png"));
        }
        return this.texturePath;
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_193783_dc;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_193787_df;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_193786_de;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        super.func_180429_a(pos, blockIn);
    }

    public boolean func_70601_bi() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return pos.func_177956_o() > 62 && this.func_70814_o() && this.field_70170_p.func_175710_j(pos) && this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70170_p.func_72935_r() && this.field_70170_p.func_72855_b(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ());
    }

    protected boolean func_70814_o() {
        BlockPos pos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        return this.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos) <= 8;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.hasSkinVariants()) {
            compound.func_74768_a("Variant", this.getVariant());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.hasSkinVariants()) {
            this.setVariant(compound.func_74762_e("Variant"));
        }
    }
}

