/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.entity.stone;

import com.teammetallurgy.atum.entity.stone.EntityStoneBase;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.utils.StackHelper;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityStoneguard
extends EntityStoneBase {
    private static final AttributeModifier SHIELD_ARMOR = new AttributeModifier(UUID.fromString("29c9fac8-7da1-43c0-95e7-4a3cae9bcbef"), "Stoneguard shield armor", 4.0, 0);

    public EntityStoneguard(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70728_aV = 8;
        this.func_98053_h(true);
        new PathNavigateGround((EntityLiving)this, world).func_179691_c(true);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    protected void setFriendlyAttributes() {
        super.setFriendlyAttributes();
        AttributeModifier FRIENDLY_HEALTH = new AttributeModifier(UUID.fromString("41d44fff-f8a8-47c5-a753-d7eb9f715d40"), "Friendly Stoneguard health", 30.0, 0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(FRIENDLY_HEALTH);
        this.func_70691_i(30.0f);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        if (this.isPlayerCreated()) {
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                ItemStack stack = this.func_184582_a(slot);
                if (stack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)stack) || !wasRecentlyHit) continue;
                this.func_70099_a(stack, 0.0f);
            }
        } else {
            super.func_82160_b(wasRecentlyHit, lootingModifier);
        }
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        int randomWeapon = MathHelper.func_76136_a((Random)this.field_70146_Z, (int)0, (int)3);
        this.setStoneguardEquipment(randomWeapon);
    }

    private void setStoneguardEquipment(int randomWeapon) {
        if (randomWeapon != 2) {
            ModifiableAttributeInstance attribute;
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(AtumItems.STONEGUARD_SHIELD));
            if (!this.field_70170_p.field_72995_K && !(attribute = (ModifiableAttributeInstance)this.func_110148_a(SharedMonsterAttributes.field_111263_d)).func_180374_a(SHIELD_ARMOR)) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(SHIELD_ARMOR);
            }
        }
        switch (randomWeapon) {
            case 0: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(AtumItems.STONEGUARD_SWORD));
                break;
            }
            case 1: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(AtumItems.STONEGUARD_CLUB));
                break;
            }
            case 2: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(AtumItems.STONEGUARD_GREATSWORD));
                break;
            }
            case 3: {
                this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(AtumItems.STONEGUARD_KHOPESH));
            }
        }
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        if (!this.isPlayerCreated()) {
            this.func_180481_a(difficulty);
            int variant = MathHelper.func_76136_a((Random)this.field_70170_p.field_73012_v, (int)0, (int)7);
            this.setVariant(variant);
        } else {
            this.setVariant(8);
        }
        return livingdata;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AtumLootTables.STONEGUARD;
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && player.func_184586_b(hand).func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                for (ItemStack held : this.func_184214_aD()) {
                    StackHelper.giveItem(player, hand, held);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }
}

