/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.teammetallurgy.atum.client.TextureManagerParticles;
import com.teammetallurgy.atum.client.particle.IAtumParticleFactory;
import com.teammetallurgy.atum.client.particle.ParticleDrop;
import com.teammetallurgy.atum.client.particle.ParticleLightSparkle;
import com.teammetallurgy.atum.client.particle.ParticleMontu;
import com.teammetallurgy.atum.client.particle.ParticleRaFire;
import com.teammetallurgy.atum.client.particle.ParticleSwirl;
import com.teammetallurgy.atum.client.particle.ParticleTefnut;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEmitter;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class AtumParticles {
    private static final Map<String, IAtumParticleFactory> particleTypes = Maps.newHashMap();
    protected final ArrayDeque<Particle>[][] fxLayers = new ArrayDeque[4][];
    private final Queue<ParticleEmitter> particleEmitters = Queues.newArrayDeque();
    private static final Queue<Particle> queue = Queues.newArrayDeque();
    private World world;

    public AtumParticles() {
        this.world = Minecraft.func_71410_x().field_71441_e;
        for (int i = 0; i < 4; ++i) {
            this.fxLayers[i] = new ArrayDeque[2];
            for (int j = 0; j < 2; ++j) {
                this.fxLayers[i][j] = Queues.newArrayDeque();
            }
        }
        this.register();
    }

    public void register() {
        this.registerParticle(Types.ANUBIS.getParticleName(), new ParticleSwirl.Anubis());
        this.registerParticle(Types.ANUBIS_SKULL.getParticleName(), new ParticleSwirl.AnubisSkull());
        this.registerParticle(Types.GAS.getParticleName(), new ParticleSwirl.Gas());
        this.registerParticle(Types.GEB.getParticleName(), new ParticleSwirl.Geb());
        this.registerParticle(Types.HORUS.getParticleName(), new ParticleSwirl.Horus());
        this.registerParticle(Types.ISIS.getParticleName(), new ParticleSwirl.Isis());
        this.registerParticle(Types.LIGHT_SPARKLE.getParticleName(), new ParticleLightSparkle.Factory());
        this.registerParticle(Types.MONTU.getParticleName(), new ParticleMontu.Factory());
        this.registerParticle(Types.NUIT_BLACK.getParticleName(), new ParticleSwirl.NuitBlack());
        this.registerParticle(Types.NUIT_WHITE.getParticleName(), new ParticleSwirl.NuitWhite());
        this.registerParticle(Types.SETH.getParticleName(), new ParticleDrop.Seth());
        this.registerParticle(Types.SHU.getParticleName(), new ParticleSwirl.Shu());
        this.registerParticle(Types.RA_FIRE.getParticleName(), new ParticleRaFire.Factory());
        this.registerParticle(Types.TEFNUT.getParticleName(), new ParticleTefnut.Factory());
        this.registerParticle(Types.TEFNUT_DROP.getParticleName(), new ParticleDrop.Tefnut());
        this.registerParticle(Types.TAR.getParticleName(), new ParticleDrop.Tar());
    }

    private void registerParticle(String name, IAtumParticleFactory factory) {
        particleTypes.put(name, factory);
    }

    @Nullable
    public Particle spawnEffectParticle(String particleName, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle;
        IAtumParticleFactory factory = particleTypes.get(particleName);
        if (factory != null && (particle = factory.createParticle(particleName, world, x, y, z, xSpeed, ySpeed, zSpeed)) != null) {
            this.addEffect(particle);
            return particle;
        }
        return null;
    }

    public void addEffect(Particle effect) {
        if (effect == null) {
            return;
        }
        queue.add(effect);
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            this.updateEffectLayer(i);
        }
        if (!this.particleEmitters.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (ParticleEmitter particleemitter : this.particleEmitters) {
                particleemitter.func_189213_a();
                if (particleemitter.func_187113_k()) continue;
                list.add(particleemitter);
            }
            this.particleEmitters.removeAll(list);
        }
        if (!queue.isEmpty()) {
            Particle particle = queue.poll();
            while (particle != null) {
                int k;
                int j = particle.func_70537_b();
                int n = k = particle.func_187111_c() ? 0 : 1;
                if (this.fxLayers[j][k].size() >= 16384) {
                    this.fxLayers[j][k].removeFirst();
                }
                this.fxLayers[j][k].add(particle);
                particle = queue.poll();
            }
        }
    }

    private void updateEffectLayer(int layer) {
        this.world.field_72984_F.func_76320_a(String.valueOf(layer));
        for (int i = 0; i < 2; ++i) {
            this.world.field_72984_F.func_76320_a(String.valueOf(i));
            this.tickParticleList(this.fxLayers[layer][i]);
            this.world.field_72984_F.func_76319_b();
        }
        this.world.field_72984_F.func_76319_b();
    }

    private void tickParticleList(Queue<Particle> p_187240_1_) {
        if (!p_187240_1_.isEmpty()) {
            Iterator iterator = p_187240_1_.iterator();
            while (iterator.hasNext()) {
                Particle particle = (Particle)iterator.next();
                this.tickParticle(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    private void tickParticle(Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            int i = particle.func_70537_b();
            crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
            crashreportcategory.func_189529_a("Particle Type", () -> {
                if (i == 0) {
                    return "MISC_TEXTURE";
                }
                if (i == 1) {
                    return "TERRAIN_TEXTURE";
                }
                return i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i;
            });
            throw new ReportedException(crashreport);
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        for (int i_nf = 0; i_nf < 3; ++i_nf) {
            int i = i_nf;
            for (int j = 0; j < 2; ++j) {
                if (this.fxLayers[i][j].isEmpty()) continue;
                switch (j) {
                    case 0: {
                        GlStateManager.func_179132_a((boolean)false);
                        break;
                    }
                    case 1: {
                        GlStateManager.func_179132_a((boolean)true);
                    }
                }
                switch (i) {
                    default: {
                        TextureManagerParticles.INSTANCE.bindTextureMap();
                        break;
                    }
                    case 1: {
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                for (Particle particle : this.fxLayers[i][j]) {
                    try {
                        particle.func_180434_a(bufferbuilder, entityIn, partialTicks, f, f4, f1, f2, f3);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                        crashreportcategory.func_189529_a("Particle", () -> ((Particle)particle).toString());
                        crashreportcategory.func_189529_a("Particle Type", () -> {
                            if (i == 0) {
                                return "MISC_TEXTURE";
                            }
                            if (i == 1) {
                                return "TERRAIN_TEXTURE";
                            }
                            return i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i;
                        });
                        throw new ReportedException(crashreport);
                    }
                }
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void renderLitParticles(Entity entityIn, float partialTick) {
        float f = (float)Math.PI / 180;
        float f1 = MathHelper.func_76134_b((float)(entityIn.field_70177_z * f));
        float f2 = MathHelper.func_76126_a((float)(entityIn.field_70177_z * f));
        float f3 = -f2 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * f));
        float f4 = f1 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * f));
        float f5 = MathHelper.func_76134_b((float)(entityIn.field_70125_A * f));
        for (int i = 0; i < 2; ++i) {
            ArrayDeque<Particle> queue = this.fxLayers[3][i];
            if (queue.isEmpty()) continue;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            for (Particle particle : queue) {
                particle.func_180434_a(bufferbuilder, entityIn, partialTick, f1, f5, f2, f3, f4);
            }
        }
    }

    public void clearEffects(@Nullable World world) {
        this.world = world;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.fxLayers[i][j].clear();
            }
        }
        this.particleEmitters.clear();
    }

    public static enum Types {
        ANUBIS("anubis"),
        ANUBIS_DROP("anubis_drop"),
        ANUBIS_SKULL("anubis_skull"),
        GAS("gas"),
        GEB("geb"),
        HORUS("horus"),
        ISIS("isis"),
        LIGHT_SPARKLE("light_sprakle"),
        MONTU("montu"),
        NUIT_BLACK("nuit_black"),
        NUIT_WHITE("nuit_white"),
        RA_FIRE("ra_fire"),
        SETH("seth"),
        SHU("shu"),
        TEFNUT("tefnut"),
        TEFNUT_DROP("tefnut_drop"),
        TAR("tar");

        private static final Map<String, Types> PARTICLES;
        private final String particleName;

        private Types(String particleName) {
            this.particleName = particleName;
        }

        public String getParticleName() {
            return this.particleName;
        }

        @Nullable
        public static Types getParticleFromName(String name) {
            return PARTICLES.get(name);
        }

        static {
            PARTICLES = Maps.newHashMap();
            for (Types types : Types.values()) {
                PARTICLES.put(types.particleName, types);
            }
        }
    }
}

