/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.init;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.api.recipe.RecipeHandlers;
import com.teammetallurgy.atum.api.recipe.kiln.IKilnRecipe;
import com.teammetallurgy.atum.api.recipe.kiln.KilnRecipe;
import com.teammetallurgy.atum.api.recipe.quern.IQuernRecipe;
import com.teammetallurgy.atum.api.recipe.quern.QuernRecipe;
import com.teammetallurgy.atum.api.recipe.spinningwheel.ISpinningWheelRecipe;
import com.teammetallurgy.atum.api.recipe.spinningwheel.SpinningWheelRecipe;
import com.teammetallurgy.atum.blocks.base.BlockAtumStairs;
import com.teammetallurgy.atum.blocks.glass.BlockAtumStainedGlass;
import com.teammetallurgy.atum.blocks.glass.BlockAtumStainedGlassPane;
import com.teammetallurgy.atum.blocks.linen.BlockLinen;
import com.teammetallurgy.atum.blocks.linen.BlockLinenCarpet;
import com.teammetallurgy.atum.blocks.machines.tileentity.TileEntityKiln;
import com.teammetallurgy.atum.blocks.stone.ceramic.BlockCeramic;
import com.teammetallurgy.atum.blocks.stone.ceramic.BlockCeramicSlab;
import com.teammetallurgy.atum.blocks.stone.ceramic.BlockCeramicTile;
import com.teammetallurgy.atum.blocks.stone.ceramic.BlockCeramicWall;
import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneBricks;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumItems;
import com.teammetallurgy.atum.utils.AtumRegistry;
import com.teammetallurgy.atum.utils.BlacklistOreIngredient;
import com.teammetallurgy.atum.utils.recipe.RecipeHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import org.apache.commons.lang3.StringUtils;

@Mod.EventBusSubscriber(modid="atum")
public class AtumRecipes {
    @SubscribeEvent
    public static void registerRegistries(RegistryEvent.NewRegistry event) {
        RecipeHandlers.quernRecipes = (IForgeRegistryModifiable)AtumRegistry.makeRegistry("quern_recipes", IQuernRecipe.class);
        RecipeHandlers.spinningWheelRecipes = (IForgeRegistryModifiable)AtumRegistry.makeRegistry("spinning_wheel_recipes", ISpinningWheelRecipe.class);
        RecipeHandlers.kilnRecipes = (IForgeRegistryModifiable)AtumRegistry.makeRegistry("kiln_recipes", IKilnRecipe.class);
    }

    private static void register() {
        AtumRecipes.addSmeltingRecipes();
        AtumRecipes.addBrewingRecipes();
    }

    private static void addSmeltingRecipes() {
        GameRegistry.addSmelting((Block)AtumBlocks.IRON_ORE, (ItemStack)new ItemStack(Items.field_151042_j), (float)0.7f);
        GameRegistry.addSmelting((Block)AtumBlocks.COAL_ORE, (ItemStack)new ItemStack(Items.field_151044_h), (float)0.1f);
        GameRegistry.addSmelting((Block)AtumBlocks.REDSTONE_ORE, (ItemStack)new ItemStack(Items.field_151137_ax), (float)0.7f);
        GameRegistry.addSmelting((Block)AtumBlocks.LAPIS_ORE, (ItemStack)new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), (float)0.2f);
        GameRegistry.addSmelting((Block)AtumBlocks.GOLD_ORE, (ItemStack)new ItemStack(Items.field_151043_k), (float)1.0f);
        GameRegistry.addSmelting((Block)AtumBlocks.EMERALD_ORE, (ItemStack)new ItemStack(Items.field_151166_bC), (float)1.0f);
        GameRegistry.addSmelting((Block)AtumBlocks.DIAMOND_ORE, (ItemStack)new ItemStack(Items.field_151045_i), (float)1.0f);
        GameRegistry.addSmelting((Block)AtumBlocks.PALM_LOG, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        GameRegistry.addSmelting((Block)AtumBlocks.DEADWOOD_LOG, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        GameRegistry.addSmelting((Block)AtumBlocks.LIMESTONE_CRACKED, (ItemStack)new ItemStack(AtumBlocks.LIMESTONE), (float)0.1f);
        GameRegistry.addSmelting((Block)BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.LARGE), (ItemStack)new ItemStack((Block)BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.CRACKED)), (float)0.1f);
        GameRegistry.addSmelting((Block)AtumBlocks.LIMESTONE, (ItemStack)new ItemStack((Block)BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.CARVED)), (float)0.1f);
        GameRegistry.addSmelting((Block)AtumBlocks.SAND, (ItemStack)new ItemStack(AtumBlocks.CRYSTAL_GLASS), (float)0.1f);
        GameRegistry.addSmelting((Item)AtumItems.JEWELED_FISH, (ItemStack)new ItemStack(Items.field_151074_bl, 3), (float)0.3f);
        GameRegistry.addSmelting((Item)AtumItems.GOLD_COIN, (ItemStack)new ItemStack(Items.field_151074_bl), (float)0.1f);
        GameRegistry.addSmelting((Item)AtumItems.EMMER_DOUGH, (ItemStack)new ItemStack(AtumItems.EMMER_BREAD), (float)0.1f);
        GameRegistry.addSmelting((Item)AtumItems.CAMEL_RAW, (ItemStack)new ItemStack(AtumItems.CAMEL_COOKED), (float)0.35f);
        GameRegistry.addSmelting((Item)AtumItems.ECTOPLASM, (ItemStack)new ItemStack(Items.field_151123_aH), (float)0.1f);
    }

    private static void addBrewingRecipes() {
        RecipeHelper.addBrewingRecipeWithSubPotions("dustBlaze", PotionTypes.field_185223_F);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.DUSTY_BONE), PotionTypes.field_185241_m);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.ECTOPLASM), PotionTypes.field_185236_h);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.GLISTERING_DATE), PotionTypes.field_185220_C);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.KHNUMITE), PotionTypes.field_185246_r);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.MANDIBLES), PotionTypes.field_185226_I);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.SKELETAL_FISH), PotionTypes.field_185248_t);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.WOLF_PELT), PotionTypes.field_185243_o);
        RecipeHelper.addBrewingRecipeWithSubPotions(new ItemStack(AtumItems.OPHIDIAN_TONGUE_FLOWER), PotionTypes.field_185254_z);
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b), "cropNetherWart", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185233_e));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185230_b), "cropNetherWart", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)PotionTypes.field_185233_e));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)PotionTypes.field_185230_b), "cropNetherWart", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185156_bI), (PotionType)PotionTypes.field_185233_e));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185238_j), new ItemStack(AtumItems.FERTILE_SOIL_PILE), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185240_l));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185243_o), new ItemStack(AtumItems.FERTILE_SOIL_PILE), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185245_q));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185250_v), new ItemStack(AtumItems.FERTILE_SOIL_PILE), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185251_w));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185252_x), new ItemStack(AtumItems.FERTILE_SOIL_PILE), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185253_y));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185254_z), new ItemStack(AtumItems.FERTILE_SOIL_PILE), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185219_B));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185220_C), new ItemStack(AtumItems.FERTILE_SOIL_PILE), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185222_E));
        RecipeHelper.addRecipe(PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185223_F), new ItemStack(AtumItems.FERTILE_SOIL_PILE), PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185225_H));
    }

    @SubscribeEvent
    public static void registerQuernRecipes(RegistryEvent.Register<IQuernRecipe> event) {
        RecipeHelper.addQuernRecipe("emmer_wheat", new QuernRecipe("cropEmmer", new ItemStack(AtumItems.EMMER_FLOUR), 2), event);
        RecipeHelper.addQuernRecipe("rod_blaze", new QuernRecipe("rodBlaze", new ItemStack(Items.field_151065_br, 3), 4), event);
        RecipeHelper.addQuernRecipe("marl", new QuernRecipe(AtumBlocks.MARL, new ItemStack(Items.field_151119_aD, 3), 2), event);
        RecipeHelper.addQuernRecipe("gravel", new QuernRecipe("gravel", new ItemStack(Items.field_151145_ak), 3), event);
        RecipeHelper.addQuernRecipe("sugarcane", new QuernRecipe("sugarcane", new ItemStack(Items.field_151102_aT, 2), 2), event);
        RecipeHelper.addQuernRecipe("black", new QuernRecipe(AtumItems.ANPUTS_FINGERS_SPORES, new ItemStack(AtumItems.DYE_BLACK, 2), 1), event);
        RecipeHelper.addQuernRecipe("brown_shrub", new QuernRecipe((Block)AtumBlocks.SHRUB, new ItemStack(AtumItems.DYE_BROWN, 2), 1), event);
        RecipeHelper.addQuernRecipe("brown_weed", new QuernRecipe((Block)AtumBlocks.WEED, new ItemStack(AtumItems.DYE_BROWN, 2), 1), event);
        RecipeHelper.addQuernRecipe("green", new QuernRecipe(AtumBlocks.OPHIDIAN_TONGUE, new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.GREEN.func_176767_b()), 1), event);
        RecipeHelper.addQuernRecipe("red", new QuernRecipe(AtumItems.DATE, new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()), 1), event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150327_N, BlockFlower.EnumFlowerType.DANDELION, EnumDyeColor.YELLOW, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.POPPY, EnumDyeColor.RED, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.BLUE_ORCHID, EnumDyeColor.LIGHT_BLUE, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.ALLIUM, EnumDyeColor.MAGENTA, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.HOUSTONIA, EnumDyeColor.SILVER, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.RED_TULIP, EnumDyeColor.RED, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.ORANGE_TULIP, EnumDyeColor.ORANGE, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.WHITE_TULIP, EnumDyeColor.SILVER, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.PINK_TULIP, EnumDyeColor.PINK, event);
        RecipeHelper.addFlowerRecipeOre((Block)Blocks.field_150328_O, BlockFlower.EnumFlowerType.OXEYE_DAISY, EnumDyeColor.SILVER, event);
        RecipeHelper.addQuernRecipe("beetroot", new QuernRecipe(Items.field_185164_cV, new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.RED.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("sunflower", new QuernRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SUNFLOWER.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.YELLOW.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("lilac", new QuernRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.SYRINGA.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.MAGENTA.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("rose_bush", new QuernRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.ROSE.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.RED.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("peony", new QuernRecipe(new ItemStack((Block)Blocks.field_150398_cm, 1, BlockDoublePlant.EnumPlantType.PAEONIA.func_176936_a()), new ItemStack(Items.field_151100_aR, 4, EnumDyeColor.PINK.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("rafflesia", new QuernRecipe("plantRafflesia", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.RED.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("plant_flax", new QuernRecipe("plantFlax", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.LIGHT_BLUE.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("clover", new QuernRecipe("flowerClover", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.SILVER.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("swampflower", new QuernRecipe("flowerSwampflower", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.CYAN.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("glowflower", new QuernRecipe("flowerGlowflower", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.CYAN.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("blue_hydrangea", new QuernRecipe("flowerBlueHydrangea", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.LIGHT_BLUE.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("orange_cosmos", new QuernRecipe("flowerOrangeCosmos", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.ORANGE.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("pink_daffodil", new QuernRecipe("flowerPinkDaffodil", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.PINK.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("wildflower", new QuernRecipe("flowerWildflower", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.MAGENTA.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("violet_flower", new QuernRecipe("flowerViolet", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.PURPLE.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("bromeliad", new QuernRecipe("flowerBromeliad", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.RED.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("wilted_lily", new QuernRecipe("flowerWiltedLily", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.GRAY.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("pink_hibiscus", new QuernRecipe("flowerPinkHibiscus", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.PINK.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("burning_blossom", new QuernRecipe("flowerBurningBlossom", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.ORANGE.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("miners_delight", new QuernRecipe("flowerMinersDelight", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.PINK.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("icy_iris", new QuernRecipe("flowerIcyIris", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.LIGHT_BLUE.func_176767_b()), 2), event);
        RecipeHelper.addQuernRecipe("rose", new QuernRecipe("flowerRose", new ItemStack(Items.field_151100_aR, 3, EnumDyeColor.RED.func_176767_b()), 2), event);
    }

    @SubscribeEvent
    public static void registerKilnRecipes(RegistryEvent.Register<IKilnRecipe> event) {
        AtumRegistry.registerRecipe("marl", new KilnRecipe(AtumBlocks.MARL, new ItemStack(BlockCeramic.getCeramicBlocks(EnumDyeColor.WHITE)), 0.1f), event);
    }

    public static void addKilnRecipes() {
        for (ItemStack input : FurnaceRecipes.func_77602_a().func_77599_b().keySet()) {
            ItemStack output = (ItemStack)FurnaceRecipes.func_77602_a().func_77599_b().get(input);
            if (input.func_190926_b() || output.func_190926_b()) continue;
            ResourceLocation inputId = input.func_77973_b().getRegistryName();
            ResourceLocation outputID = output.func_77973_b().getRegistryName();
            if (inputId == null || outputID == null || TileEntityKiln.canKilnNotSmelt(input) || TileEntityKiln.canKilnNotSmelt(output)) continue;
            int inMeta = input.func_77960_j();
            int outMeta = output.func_77960_j();
            ResourceLocation id = new ResourceLocation("atum", inputId.func_110623_a() + "_" + (inMeta > 0 && inMeta != Short.MAX_VALUE ? inMeta + "_" : "") + outputID.func_110623_a() + (outMeta > 0 && outMeta != Short.MAX_VALUE ? "_" + outMeta : ""));
            if (!RecipeHandlers.kilnRecipes.containsKey(id)) {
                RecipeHandlers.kilnRecipes.register(new KilnRecipe(input, output, FurnaceRecipes.func_77602_a().func_151398_b(output)).setRegistryName(id));
                continue;
            }
            Atum.LOG.error("Kiln Recipe with ID: " + id + " already exists");
        }
    }

    @SubscribeEvent
    public static void registerSpinningwheelRecipes(RegistryEvent.Register<ISpinningWheelRecipe> event) {
        AtumRegistry.registerRecipe("flax", new SpinningWheelRecipe("cropFlax", new ItemStack(AtumItems.LINEN_THREAD, 3), 4), event);
        AtumRegistry.registerRecipe("wolf_pelt", new SpinningWheelRecipe(AtumItems.WOLF_PELT, new ItemStack(Items.field_151007_F, 2), 5), event);
        AtumRegistry.registerRecipe("cloth_scrap", new SpinningWheelRecipe(AtumItems.SCRAP, new ItemStack(AtumItems.LINEN_THREAD), 2), event);
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistry registry = event.getRegistry();
        ResourceLocation crystal = new ResourceLocation("atum", "crystal_glass");
        ResourceLocation framed = new ResourceLocation("atum", "framed_glass");
        ResourceLocation linen = new ResourceLocation("atum", "linen");
        ResourceLocation ceramic = new ResourceLocation("atum", "ceramic");
        for (EnumDyeColor color : EnumDyeColor.values()) {
            String colorName = StringUtils.capitalize((String)color.func_176762_d().replace("silver", "lightGray"));
            AtumRegistry.registerRecipe("crystal_" + colorName, new ShapedOreRecipe(crystal, new ItemStack(BlockAtumStainedGlass.getGlass(AtumBlocks.CRYSTAL_GLASS, color), 8), new Object[]{"GGG", "GDG", "GGG", Character.valueOf('G'), AtumBlocks.CRYSTAL_GLASS, Character.valueOf('D'), "dye" + colorName}), event);
            AtumRegistry.registerRecipe("framed_" + colorName, new ShapedOreRecipe(framed, new ItemStack(BlockAtumStainedGlass.getGlass(AtumBlocks.FRAMED_GLASS, color), 8), new Object[]{"GGG", "GDG", "GGG", Character.valueOf('G'), AtumBlocks.FRAMED_GLASS, Character.valueOf('D'), "dye" + colorName}), event);
            AtumRegistry.registerRecipe("crystal_to_framed_" + colorName, new ShapedOreRecipe(framed, BlockAtumStainedGlass.getGlass(AtumBlocks.FRAMED_GLASS, color), new Object[]{" S ", "SGS", " S ", Character.valueOf('S'), "stickWood", Character.valueOf('G'), BlockAtumStainedGlass.getGlass(AtumBlocks.CRYSTAL_GLASS, color)}), event);
            AtumRegistry.registerRecipe("thin_crystal_" + colorName, new ShapedOreRecipe(crystal, new ItemStack(BlockAtumStainedGlassPane.getGlass(AtumBlocks.CRYSTAL_GLASS, color), 16), new Object[]{"GGG", "GGG", Character.valueOf('G'), BlockAtumStainedGlass.getGlass(AtumBlocks.CRYSTAL_GLASS, color)}), event);
            AtumRegistry.registerRecipe("thin_framed_" + colorName, new ShapedOreRecipe(framed, new ItemStack(BlockAtumStainedGlassPane.getGlass(AtumBlocks.FRAMED_GLASS, color), 16), new Object[]{"GGG", "GGG", Character.valueOf('G'), BlockAtumStainedGlass.getGlass(AtumBlocks.FRAMED_GLASS, color)}), event);
            if (color != EnumDyeColor.WHITE) {
                AtumRegistry.registerRecipe("linen_" + colorName, new ShapelessOreRecipe(linen, new ItemStack(BlockLinen.getLinen(color)), new Object[]{"dye" + colorName, BlockLinen.getLinen(EnumDyeColor.WHITE)}), event);
                AtumRegistry.registerRecipe("ceramic_" + colorName, new ShapelessOreRecipe(ceramic, new ItemStack(BlockCeramic.getCeramicBlocks(color)), new Object[]{"dye" + colorName, BlockCeramic.getCeramicBlocks(EnumDyeColor.WHITE)}), event);
            }
            AtumRegistry.registerRecipe("ceramic_tile_" + colorName, new ShapedOreRecipe(ceramic, new ItemStack(BlockCeramicTile.getTile(color), 3), new Object[]{"CC", Character.valueOf('C'), BlockCeramic.getCeramicBlocks(color)}), event);
            AtumRegistry.registerRecipe("ceramic_slab_" + colorName, new ShapedOreRecipe(ceramic, new ItemStack(BlockCeramicSlab.getSlab(color), 6), new Object[]{"CCC", Character.valueOf('C'), BlockCeramic.getCeramicBlocks(color)}), event);
            AtumRegistry.registerRecipe("ceramic_stairs_" + colorName, new ShapedOreRecipe(ceramic, new ItemStack(BlockAtumStairs.getCeramicStairs(color), 4), new Object[]{"C  ", "CC ", "CCC", Character.valueOf('C'), BlockCeramic.getCeramicBlocks(color)}).setMirrored(true), event);
            AtumRegistry.registerRecipe("ceramic_wall_" + colorName, new ShapedOreRecipe(ceramic, new ItemStack(BlockCeramicWall.getWall(color), 6), new Object[]{"CCC", "CCC", Character.valueOf('C'), BlockCeramic.getCeramicBlocks(color)}), event);
            AtumRegistry.registerRecipe("linen_carpet_" + colorName, new ShapedOreRecipe(linen, new ItemStack(BlockLinenCarpet.getLinenBlock(color), 5), new Object[]{"LLL", Character.valueOf('L'), BlockLinen.getLinen(color)}), event);
        }
        AtumRecipes.register();
        AtumRecipes.fixOreDictEntries((IForgeRegistry<IRecipe>)registry);
    }

    private static void fixOreDictEntries(IForgeRegistry<IRecipe> registry) {
        IForgeRegistryModifiable recipes = (IForgeRegistryModifiable)registry;
        ResourceLocation stick = new ResourceLocation("stick");
        ResourceLocation torch = new ResourceLocation("torch");
        ResourceLocation ladder = new ResourceLocation("ladder");
        ResourceLocation chest = new ResourceLocation("chest");
        ResourceLocation trapdoor = new ResourceLocation("trapdoor");
        recipes.remove(stick);
        registry.register(new ShapedOreRecipe(stick, new ItemStack(Items.field_151055_y, 4), new Object[]{"P", "P", Character.valueOf('P'), "plankWood"}).setRegistryName(new ResourceLocation("atum", "stick")));
        registry.register(new ShapedOreRecipe(stick, new ItemStack(Items.field_151055_y, 4), new Object[]{"P", "P", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE)}).setRegistryName(stick));
        recipes.remove(torch);
        registry.register(new ShapedOreRecipe(torch, new ItemStack(Blocks.field_150478_aa, 4), new Object[]{"C", "S", Character.valueOf('C'), new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), Character.valueOf('S'), Items.field_151055_y}).setRegistryName(torch));
        recipes.remove(ladder);
        registry.register(new ShapedOreRecipe(ladder, new ItemStack(Blocks.field_150468_ap, 3), new Object[]{"S S", "SSS", "S S", Character.valueOf('S'), "stickWood"}).setRegistryName(ladder));
        recipes.remove(chest);
        registry.register(new ShapedOreRecipe(chest, new ItemStack((Block)Blocks.field_150486_ae), new Object[]{"PPP", "P P", "PPP", Character.valueOf('P'), "plankWood"}).setRegistryName(new ResourceLocation("atum", "chest")));
        registry.register(new ShapedOreRecipe(chest, new ItemStack((Block)Blocks.field_150486_ae), new Object[]{"PPP", "P P", "PPP", Character.valueOf('P'), new ItemStack(Blocks.field_150344_f, 1, Short.MAX_VALUE)}).setRegistryName(chest));
        recipes.remove(trapdoor);
        registry.register(new ShapedOreRecipe(trapdoor, new ItemStack(Blocks.field_150415_aT, 2), new Object[]{"PPP", "PPP", Character.valueOf('P'), "plankWood"}).setRegistryName(trapdoor));
        ResourceLocation sword = new ResourceLocation("stone_sword");
        ResourceLocation shovel = new ResourceLocation("stone_shovel");
        ResourceLocation pickaxe = new ResourceLocation("stone_pickaxe");
        ResourceLocation hoe = new ResourceLocation("stone_hoe");
        ResourceLocation axe = new ResourceLocation("stone_axe");
        ResourceLocation furnace = new ResourceLocation("furnace");
        BlacklistOreIngredient cobblestone = new BlacklistOreIngredient("cobblestone", stack -> stack.func_77973_b() == Item.func_150898_a((Block)AtumBlocks.LIMESTONE_CRACKED));
        recipes.remove(sword);
        registry.register(new ShapedOreRecipe(sword, Items.field_151052_q, new Object[]{"C", "C", "S", Character.valueOf('C'), cobblestone, Character.valueOf('S'), "stickWood"}).setRegistryName(sword));
        recipes.remove(shovel);
        registry.register(new ShapedOreRecipe(shovel, Items.field_151051_r, new Object[]{"C", "S", "S", Character.valueOf('C'), cobblestone, Character.valueOf('S'), "stickWood"}).setRegistryName(shovel));
        recipes.remove(pickaxe);
        registry.register(new ShapedOreRecipe(pickaxe, Items.field_151050_s, new Object[]{"CCC", " S ", " S ", Character.valueOf('C'), cobblestone, Character.valueOf('S'), "stickWood"}).setRegistryName(pickaxe));
        recipes.remove(hoe);
        registry.register(new ShapedOreRecipe(hoe, Items.field_151018_J, new Object[]{"CC", " S", " S", Character.valueOf('C'), cobblestone, Character.valueOf('S'), "stickWood"}).setRegistryName(hoe));
        recipes.remove(axe);
        registry.register(new ShapedOreRecipe(axe, Items.field_151049_t, new Object[]{"CC", "CS", " S", Character.valueOf('C'), cobblestone, Character.valueOf('S'), "stickWood"}).setRegistryName(axe));
        recipes.remove(furnace);
        registry.register(new ShapedOreRecipe(furnace, Blocks.field_150460_al, new Object[]{"CCC", "C C", "CCC", Character.valueOf('C'), cobblestone}).setRegistryName(furnace));
    }
}

