/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration;

import com.teammetallurgy.atum.Atum;
import com.teammetallurgy.atum.integration.IModIntegration;
import com.teammetallurgy.atum.integration.thaumcraft.Thaumcraft;
import com.teammetallurgy.atum.integration.theoneprobe.TOPSupport;
import com.teammetallurgy.atum.utils.AtumConfig;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.Loader;

public class IntegrationHandler {
    public static final IntegrationHandler INSTANCE = new IntegrationHandler();
    private final NonNullList<IModIntegration> integratedMods = NonNullList.func_191196_a();
    private HashMap<String, Class<? extends IModIntegration>> mods = new HashMap();

    public void initModIntegration() {
        this.mods.put("thaumcraft", Thaumcraft.class);
        this.mods.put("theoneprobe", TOPSupport.class);
        List enabledModSupport = this.mods.keySet().stream().filter(modid -> AtumConfig.config.get("mod integration", modid, true).getBoolean()).collect(Collectors.toList());
        AtumConfig.config.save();
        this.mods.entrySet().stream().filter(entry -> enabledModSupport.contains(entry.getKey()) && Loader.isModLoaded((String)((String)entry.getKey()))).forEach(entry -> {
            try {
                this.integratedMods.add(((Class)entry.getValue()).newInstance());
            }
            catch (Exception e) {
                Atum.LOG.error("Failed to load mod integration handler");
                e.printStackTrace();
            }
        });
    }

    public void preInit() {
        for (IModIntegration modSupport : this.integratedMods) {
            try {
                modSupport.preInit();
            }
            catch (Exception e) {
                Atum.LOG.error("Failed to load mod integration from " + modSupport.getClass() + " in PreInit");
                e.printStackTrace();
            }
        }
    }

    public void init() {
        for (IModIntegration modSupport : this.integratedMods) {
            try {
                modSupport.init();
            }
            catch (Exception e) {
                Atum.LOG.error("Failed to load mod integration from " + modSupport.getClass() + " in Init");
                e.printStackTrace();
            }
        }
    }

    public void clientSide() {
        for (IModIntegration modSupport : this.integratedMods) {
            try {
                modSupport.clientSide();
            }
            catch (Exception e) {
                Atum.LOG.error("Failed to load mod integration from " + modSupport.getClass() + " on the client.");
                e.printStackTrace();
            }
        }
    }
}

