/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.integration.jei.kiln;

import com.teammetallurgy.atum.client.gui.block.GuiKiln;
import com.teammetallurgy.atum.integration.jei.kiln.KilnRecipeWrapper;
import com.teammetallurgy.atum.utils.AtumUtils;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;

public class KilnRecipeCategory
implements IRecipeCategory<KilnRecipeWrapper> {
    private final IDrawableStatic background;
    private final IDrawableAnimated animatedFlame;
    private final IDrawableAnimated arrow;

    public KilnRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiKiln.KILN_GUI, 35, 14, 71, 84);
        IDrawableStatic staticFlame = guiHelper.createDrawable(GuiKiln.KILN_GUI, 176, 0, 14, 14);
        this.animatedFlame = guiHelper.createAnimatedDrawable(staticFlame, 300, IDrawableAnimated.StartDirection.TOP, true);
        this.arrow = guiHelper.drawableBuilder(GuiKiln.KILN_GUI, 176, 14, 19, 8).buildAnimated(200, IDrawableAnimated.StartDirection.TOP, false);
    }

    @Nonnull
    public String getUid() {
        return "atum.kiln";
    }

    @Nonnull
    public String getTitle() {
        return AtumUtils.format(this.getUid());
    }

    @Nonnull
    public String getModName() {
        return "Atum2";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull KilnRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 35, 0);
        guiItemStacks.init(5, false, 35, 48);
        guiItemStacks.set(ingredients);
        guiItemStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex >= 5) {
                boolean showAdvanced;
                boolean bl = showAdvanced = Minecraft.func_71410_x().field_71474_y.field_82882_x || GuiScreen.func_146272_n();
                if (showAdvanced) {
                    tooltip.add(TextFormatting.DARK_GRAY + AtumUtils.format("jei.tooltip.recipe.id", recipeWrapper.getId()));
                }
            }
        });
    }

    public void drawExtras(Minecraft minecraft) {
        this.animatedFlame.draw(minecraft, 1, 17);
        this.arrow.draw(minecraft, 43, 38);
    }
}

