/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.items.artifacts.thoth;

import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.gen.structure.pyramid.PyramidPieces;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemCompass;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemThothsDirection
extends ItemCompass {
    private BlockPos pyramidPos;
    private int searchTime;
    private boolean isSearching = false;

    public ItemThothsDirection() {
        this.func_77625_d(1);
        this.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){
            @SideOnly(value=Side.CLIENT)
            double rotation;
            @SideOnly(value=Side.CLIENT)
            double rota;
            @SideOnly(value=Side.CLIENT)
            long lastUpdateTick;

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World world, @Nullable EntityLivingBase livingBase) {
                double angle;
                EntityLivingBase entity;
                if (livingBase == null && !stack.func_82839_y()) {
                    return 0.0f;
                }
                boolean livingNotNull = livingBase != null;
                Object object = entity = livingNotNull ? livingBase : stack.func_82836_z();
                if (world == null) {
                    world = entity.field_70170_p;
                }
                if (world.field_73011_w.getDimension() == AtumConfig.DIMENSION_ID) {
                    if (ItemThothsDirection.this.isSearching) {
                        angle = this.spin(world);
                    } else {
                        double d1 = livingNotNull ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                        d1 = MathHelper.func_191273_b((double)(d1 / 360.0), (double)1.0);
                        double pyramidAngle = this.getPyramidToAngle(world, (Entity)entity) / (Math.PI * 2);
                        angle = 0.5 - (d1 - 0.25 - pyramidAngle);
                    }
                } else {
                    angle = Math.random();
                }
                if (livingNotNull) {
                    angle = this.wobble(world, angle);
                }
                return MathHelper.func_188207_b((float)((float)angle), (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double spin(World world) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    long delta = world.func_82737_E() - this.lastUpdateTick;
                    this.lastUpdateTick = world.func_82737_E();
                    this.rotation += 0.05 * (double)delta;
                    this.rotation = MathHelper.func_191273_b((double)this.rotation, (double)1.0);
                }
                return this.rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World world, double angle) {
                if (world.func_82737_E() != this.lastUpdateTick) {
                    this.lastUpdateTick = world.func_82737_E();
                    double wobbleAngle = angle - this.rotation;
                    wobbleAngle = MathHelper.func_191273_b((double)(wobbleAngle + 0.5), (double)1.0) - 0.5;
                    this.rota += wobbleAngle * 0.1;
                    this.rota *= 0.8;
                    this.rotation = MathHelper.func_191273_b((double)(this.rotation + this.rota), (double)1.0);
                }
                return this.rotation;
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame frame) {
                int facingDirection = frame.field_174860_b != null ? frame.field_174860_b.func_176736_b() : 0;
                return MathHelper.func_188209_b((int)(180 + facingDirection * 90));
            }

            @SideOnly(value=Side.CLIENT)
            private double getPyramidToAngle(World world, Entity entity) {
                if (ItemThothsDirection.this.isSearching) {
                    return 1.0;
                }
                if (ItemThothsDirection.this.pyramidPos != null) {
                    BlockPos structurePos = ItemThothsDirection.this.pyramidPos;
                    return Math.atan2((double)structurePos.func_177952_p() - entity.field_70161_v, (double)structurePos.func_177958_n() - entity.field_70165_t);
                }
                return MathHelper.func_191273_b((double)this.wobble(world, Math.random()), (double)1.0);
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public EnumRarity func_77613_e(@Nonnull ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        player.func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".searching", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)), true);
        this.searchTime = 60;
        return super.func_77659_a(world, player, hand);
    }

    public void func_77663_a(@Nonnull ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (AtumConfig.PYRAMID_ENABLED) {
            if (this.searchTime > 1) {
                this.isSearching = true;
                --this.searchTime;
            }
            if (this.searchTime == 1) {
                this.searchTime = 0;
                this.isSearching = false;
                if (!world.field_72995_K && entity instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)entity;
                    WorldServer worldServer = (WorldServer)world;
                    BlockPos pos = worldServer.func_72863_F().field_186029_c.func_180513_a((World)worldServer, String.valueOf(PyramidPieces.PYRAMID), player.func_180425_c(), true);
                    if (pos != null) {
                        player.func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".found", new Object[]{player.func_184812_l_() ? "X=" + pos.func_177958_n() + " Y=" + pos.func_177956_o() + " Z=" + pos.func_177952_p() : ""}).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA)), true);
                        this.pyramidPos = pos;
                    } else {
                        player.func_146105_b(new TextComponentTranslation(this.func_77658_a() + ".searchingFail", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)), true);
                    }
                }
            }
        }
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, List<String> tooltip, ITooltipFlag tooltipType) {
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)(this.func_77658_a() + ".line1"), (Object[])new Object[0]));
            tooltip.add(TextFormatting.DARK_PURPLE + I18n.func_135052_a((String)(this.func_77658_a() + ".line2"), (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)(this.func_77658_a() + ".line3"), (Object[])new Object[0]) + " " + TextFormatting.DARK_GRAY + "[SHIFT]");
        }
    }
}

