/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.network.packet;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Packet<REQ extends Packet<REQ>>
implements IMessage,
IMessageHandler<REQ, REQ> {
    public REQ onMessage(REQ message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            this.runServer(message, (EntityPlayer)ctx.getServerHandler().field_147369_b);
        } else {
            this.runClient(message, this.getPlayerClient());
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void runClient(REQ packet, EntityPlayer player) {
        Minecraft.func_71410_x().func_152344_a(() -> packet.handleClientSide(player));
    }

    private void runServer(REQ packet, EntityPlayer player) {
        Objects.requireNonNull(player.func_184102_h()).func_152344_a(() -> packet.handleServerSide(player));
    }

    @SideOnly(value=Side.CLIENT)
    public EntityPlayer getPlayerClient() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.fromBytes(new PacketBuffer(buf));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        this.toBytes(new PacketBuffer(buf));
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract void handleClientSide(EntityPlayer var1);

    protected abstract void handleServerSide(EntityPlayer var1);

    protected abstract void toBytes(PacketBuffer var1);

    protected abstract void fromBytes(PacketBuffer var1) throws IOException;
}

