/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.utils;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StackHelper {
    public static NBTTagCompound getTag(@Nonnull ItemStack stack) {
        if (!StackHelper.hasTag(stack)) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean hasTag(@Nonnull ItemStack stack) {
        return stack.func_77942_o();
    }

    public static boolean hasKey(@Nonnull ItemStack stack, String string) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(string);
    }

    public static void giveItem(EntityPlayer player, EnumHand hand, @Nonnull ItemStack stack) {
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        } else if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
    }

    public static void dropInventoryItems(World world, BlockPos pos, IInventory inventory) {
        for (int slot = 0; slot < inventory.func_70302_i_(); ++slot) {
            ItemStack stack = inventory.func_70301_a(slot);
            if (stack.func_190926_b()) continue;
            StackHelper.spawnItemStack(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack);
        }
    }

    public static void spawnItemStack(World world, double x, double y, double z, @Nonnull ItemStack stack) {
        Random random = new Random();
        float xOffset = random.nextFloat() * 0.8f + 0.1f;
        float yOffset = random.nextFloat() * 0.8f + 0.1f;
        float zOffset = random.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            EntityItem item = new EntityItem(world, x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, stack.func_77979_a(random.nextInt(21) + 10));
            item.field_70159_w = random.nextGaussian() * (double)0.05f;
            item.field_70181_x = random.nextGaussian() * (double)0.05f + (double)0.2f;
            item.field_70179_y = random.nextGaussian() * (double)0.05f;
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)item);
        }
    }

    public static boolean areStacksEqualIgnoreSize(@Nonnull ItemStack stackA, @Nonnull ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return false;
        }
        if (stackA.func_77973_b() != stackB.func_77973_b()) {
            return false;
        }
        if (stackA.func_77960_j() != stackB.func_77960_j()) {
            return false;
        }
        return (stackA.func_77978_p() == null || stackA.func_77978_p().equals((Object)stackB.func_77978_p())) && stackA.areCapsCompatible(stackB);
    }
}

