/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world;

import com.teammetallurgy.atum.blocks.BlockSandLayers;
import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.network.NetworkHandler;
import com.teammetallurgy.atum.network.packet.PacketStormStrength;
import com.teammetallurgy.atum.network.packet.PacketWeather;
import com.teammetallurgy.atum.utils.AtumConfig;
import com.teammetallurgy.atum.world.AtumDimension;
import com.teammetallurgy.atum.world.ChunkGeneratorAtum;
import com.teammetallurgy.atum.world.biome.base.AtumBiomeProvider;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.DerivedWorldInfo;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="atum")
public class WorldProviderAtum
extends WorldProvider {
    private static BlockPos usePos;
    public boolean hasStartStructureSpawned;
    public boolean isStorming;
    public int stormTime;
    public float prevStormStrength;
    public float stormStrength;
    private int updateLCG = new Random().nextInt();
    private long lastUpdateTime;

    @Nonnull
    public DimensionType func_186058_p() {
        return AtumDimension.ATUM;
    }

    protected void func_76572_b() {
        this.field_191067_f = true;
        this.field_76578_c = new AtumBiomeProvider(this.field_76579_a.func_72912_H());
        NBTTagCompound tagCompound = this.field_76579_a.func_72912_H().getDimensionData(this.field_76579_a.field_73011_w.getDimension());
        this.hasStartStructureSpawned = this.field_76579_a instanceof WorldServer && tagCompound.func_74767_n("HasStartStructureSpawned");
        this.isStorming = this.field_76579_a instanceof WorldServer && tagCompound.func_74767_n("IsStorming");
    }

    @Nonnull
    public IChunkGenerator func_186060_c() {
        return new ChunkGeneratorAtum(this.field_76579_a, this.field_76579_a.func_72905_C(), true, this.field_76579_a.func_72912_H().func_82571_y());
    }

    public void setWorldTime(long time) {
        if (time == 24000L && this.field_76579_a.func_72912_H() instanceof DerivedWorldInfo) {
            ((DerivedWorldInfo)this.field_76579_a.func_72912_H()).field_76115_a.func_76068_b(time);
        }
        super.setWorldTime(time);
    }

    @SubscribeEvent
    public static void onUseBucket(PlayerInteractEvent.RightClickBlock event) {
        usePos = event.getPos();
    }

    public boolean func_177500_n() {
        if (usePos != null) {
            return this.field_76579_a.func_180494_b(usePos) != AtumBiomes.OASIS && usePos.func_177956_o() > 49;
        }
        return true;
    }

    public boolean func_76566_a(int x, int z) {
        BlockPos pos = new BlockPos(x, 0, z);
        if (this.field_76579_a.func_180494_b(pos).func_185352_i()) {
            return true;
        }
        Block spawnBlock = this.field_76579_a.func_184141_c(pos).func_177230_c();
        return spawnBlock == AtumBlocks.SAND || spawnBlock == AtumBlocks.FERTILE_SOIL || spawnBlock == AtumBlocks.LIMESTONE_GRAVEL;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float par1, float par2) {
        float f = MathHelper.func_76134_b((float)(par1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f;
        if (f < 0.2f) {
            f = 0.2f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        float f1 = 0.9f * f;
        float f2 = 0.75f * f;
        float f3 = 0.6f * f;
        return new Vec3d((double)f1, (double)f2, (double)f3);
    }

    public void func_186057_q() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74757_a("HasStartStructureSpawned", this.hasStartStructureSpawned);
        tagCompound.func_74757_a("IsStorming", this.isStorming);
        this.field_76579_a.func_72912_H().setDimensionData(this.field_76579_a.field_73011_w.getDimension(), tagCompound);
    }

    public void calculateInitialWeather() {
        super.calculateInitialWeather();
        if (this.isStorming) {
            this.stormStrength = 1.0f;
        }
    }

    private boolean canPlaceSandAt(BlockPos pos, Biome biome) {
        IBlockState state = this.field_76579_a.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() == AtumBlocks.SAND || state.func_177230_c() == AtumBlocks.LIMESTONE_GRAVEL || !ChunkGeneratorAtum.canPlaceSandLayer(this.field_76579_a, pos, biome)) {
            return false;
        }
        state = this.field_76579_a.func_180495_p(pos);
        if (state.func_177230_c().func_176200_f((IBlockAccess)this.field_76579_a, pos)) {
            state = this.field_76579_a.func_180495_p(pos.func_177977_b());
            BlockFaceShape blockFaceShape = state.func_193401_d((IBlockAccess)this.field_76579_a, pos.func_177977_b(), EnumFacing.UP);
            return blockFaceShape == BlockFaceShape.SOLID || state.func_177230_c().isLeaves(state, (IBlockAccess)this.field_76579_a, pos.func_177977_b());
        }
        return false;
    }

    public void updateWeather() {
        int cleanWeatherTime = this.field_76579_a.func_72912_H().func_176133_A();
        if (cleanWeatherTime > 0) {
            this.field_76579_a.func_72912_H().func_176142_i(--cleanWeatherTime);
            int n = this.stormTime = this.isStorming ? 1 : 2;
        }
        if (this.stormTime <= 0) {
            this.stormTime = this.isStorming ? this.field_76579_a.field_73012_v.nextInt(6000) + 6000 : this.field_76579_a.field_73012_v.nextInt(168000) + 12000;
            NetworkHandler.WRAPPER.sendToDimension((IMessage)new PacketWeather(this.isStorming, this.stormTime), this.getDimension());
        } else {
            --this.stormTime;
            if (this.stormTime <= 0) {
                this.isStorming = !this.isStorming;
            }
        }
        this.prevStormStrength = this.stormStrength;
        this.stormStrength = this.isStorming ? (this.stormStrength += 1.0f / (float)(20 * AtumConfig.SANDSTORM_TRANSITION_TIME)) : (this.stormStrength -= 1.0f / (float)(20 * AtumConfig.SANDSTORM_TRANSITION_TIME));
        this.stormStrength = MathHelper.func_76131_a((float)this.stormStrength, (float)0.0f, (float)1.0f);
        if (this.stormStrength != this.prevStormStrength || this.lastUpdateTime < System.currentTimeMillis() - 1000L) {
            NetworkHandler.WRAPPER.sendToDimension((IMessage)new PacketStormStrength(this.stormStrength), this.getDimension());
            this.lastUpdateTime = System.currentTimeMillis();
        }
        if (!this.field_76579_a.field_72995_K) {
            Iterator iterator = this.field_76579_a.getPersistentChunkIterable(((WorldServer)this.field_76579_a).func_184164_w().func_187300_b());
            while (iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                int x = chunk.field_76635_g * 16;
                int z = chunk.field_76647_h * 16;
                if (this.field_76579_a.field_73012_v.nextInt(40) != 0) continue;
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int j2 = this.updateLCG >> 2;
                BlockPos pos = this.field_76579_a.func_175725_q(new BlockPos(x + (j2 & 0xF), 0, z + (j2 >> 8 & 0xF)));
                BlockPos posDown = pos.func_177977_b();
                if (!this.field_76579_a.func_175697_a(posDown, 1)) continue;
                IBlockState sandState = this.field_76579_a.func_180495_p(pos);
                if (!(this.stormStrength > 0.9f)) continue;
                if (sandState.func_177230_c() == AtumBlocks.SAND_LAYERED) {
                    int layers = (Integer)sandState.func_177229_b((IProperty)BlockSandLayers.LAYERS);
                    if (layers >= 3) continue;
                    this.field_76579_a.func_175656_a(pos, sandState.func_177226_a((IProperty)BlockSandLayers.LAYERS, (Comparable)Integer.valueOf(++layers)));
                    continue;
                }
                if (!this.canPlaceSandAt(pos, this.field_76579_a.func_180494_b(pos))) continue;
                this.field_76579_a.func_175656_a(pos, AtumBlocks.SAND_LAYERED.func_176223_P());
            }
        }
    }
}

