/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.biome;

import com.teammetallurgy.atum.entity.animal.EntityCamel;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.biome.base.AtumBiome;
import com.teammetallurgy.atum.world.gen.feature.WorldGenOasisPond;
import com.teammetallurgy.atum.world.gen.feature.WorldGenPalm;
import com.teammetallurgy.atum.world.gen.feature.WorldGenPapyrus;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenWaterlily;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class BiomeOasis
extends AtumBiome {
    public BiomeOasis(AtumBiome.AtumBiomeProperties properties) {
        super(properties);
        this.field_76752_A = AtumBlocks.FERTILE_SOIL.func_176223_P();
        this.field_76760_I.field_76804_C = 0;
        this.atumDecorator.shrubChance = 0.0f;
        this.field_76760_I.field_76803_B = 3;
        this.field_76760_I.field_76833_y = 100;
        this.deadwoodRarity = 0.0;
        this.addSpawn(EntityCamel.class, 6, 2, 6, EnumCreatureType.CREATURE);
    }

    @Override
    public void func_180624_a(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos) {
        int x = random.nextInt(16) + 8;
        int z = random.nextInt(16) + 8;
        BlockPos height = world.func_175645_m(pos.func_177982_a(x, 0, z));
        ChunkPos chunkPos = new ChunkPos(pos);
        new WorldGenOasisPond().func_180709_b(world, random, height);
        if (random.nextFloat() <= 0.98f) {
            new WorldGenPalm(true, random.nextInt(4) + 5, true).func_180709_b(world, random, height);
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.REED)) {
            int reedsPerChunk = 50;
            for (int reeds = 0; reeds < reedsPerChunk; ++reeds) {
                int y = height.func_177956_o() * 2;
                if (y <= 0) continue;
                int randomY = random.nextInt(y);
                new WorldGenPapyrus().func_180709_b(world, random, pos.func_177982_a(x, randomY, z));
            }
        }
        if (TerrainGen.decorate((World)world, (Random)random, (ChunkPos)chunkPos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LILYPAD)) {
            for (int amount = 0; amount < 2; ++amount) {
                BlockPos waterPos;
                int y = world.func_175645_m(pos.func_177982_a(x, 0, z)).func_177956_o() * 2;
                if (y <= 0) continue;
                int randomY = random.nextInt(y);
                BlockPos lilyPos = pos.func_177982_a(x, randomY, z);
                while (lilyPos.func_177956_o() > 0 && world.func_175623_d(waterPos = lilyPos.func_177977_b())) {
                    lilyPos = waterPos;
                }
                new WorldGenWaterlily().func_180709_b(world, random, lilyPos);
            }
        }
        super.func_180624_a(world, random, pos);
    }

    @Override
    public int getModdedBiomeFoliageColor(int original) {
        return 11987573;
    }

    @Override
    public int getModdedBiomeGrassColor(int original) {
        return 11987573;
    }
}

