/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.mineshaft;

import com.google.common.collect.Lists;
import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneBricks;
import com.teammetallurgy.atum.blocks.stone.limestone.BlockLimestoneWall;
import com.teammetallurgy.atum.blocks.wood.BlockAtumPlank;
import com.teammetallurgy.atum.blocks.wood.BlockAtumTorch;
import com.teammetallurgy.atum.blocks.wood.BlockAtumTorchUnlit;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.init.AtumEntities;
import com.teammetallurgy.atum.init.AtumLootTables;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.MapGenAtumMineshaft;
import com.teammetallurgy.atum.world.gen.structure.mineshaft.StructureAtumMineshaftStart;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureAtumMineshaftPieces {
    public static void registerMineshaft() {
        MapGenStructureIO.func_143034_b(StructureAtumMineshaftStart.class, (String)String.valueOf(MapGenAtumMineshaft.MINESHAFT));
        MapGenStructureIO.func_143031_a(Corridor.class, (String)String.valueOf(new ResourceLocation("atum", "MSCorridor")));
        MapGenStructureIO.func_143031_a(Cross.class, (String)String.valueOf(new ResourceLocation("atum", "MSCrossing")));
        MapGenStructureIO.func_143031_a(Room.class, (String)String.valueOf(new ResourceLocation("atum", "MSRoom")));
        MapGenStructureIO.func_143031_a(Stairs.class, (String)String.valueOf(new ResourceLocation("atum", "MSStairs")));
    }

    private static MineshaftPiece createRandomShaftPiece(List<StructureComponent> components, Random random, int x, int y, int z, EnumFacing facing, int type, MapGenAtumMineshaft.Type mineshaftType) {
        int i = random.nextInt(100);
        if (i >= 80) {
            StructureBoundingBox box = Cross.findCrossing(components, random, x, y, z, facing);
            if (box != null) {
                return new Cross(type, random, box, facing, mineshaftType);
            }
        } else if (i >= 70) {
            StructureBoundingBox box = Stairs.findStairs(components, random, x, y, z, facing);
            if (box != null) {
                return new Stairs(type, random, box, facing, mineshaftType);
            }
        } else {
            StructureBoundingBox box = Corridor.findCorridorSize(components, random, x, y, z, facing);
            if (box != null) {
                return new Corridor(type, random, box, facing, mineshaftType);
            }
        }
        return null;
    }

    private static MineshaftPiece generateAndAddPiece(StructureComponent component, List<StructureComponent> components, Random random, int x, int y, int z, EnumFacing facing, int type) {
        if (type > 8) {
            return null;
        }
        if (Math.abs(x - component.func_74874_b().field_78897_a) <= 80 && Math.abs(z - component.func_74874_b().field_78896_c) <= 80) {
            MapGenAtumMineshaft.Type mineshaftType = ((MineshaftPiece)component).mineshaftType;
            MineshaftPiece piece = StructureAtumMineshaftPieces.createRandomShaftPiece(components, random, x, y, z, facing, type + 1, mineshaftType);
            if (piece != null) {
                components.add(piece);
                piece.func_74861_a(component, components, random);
            }
            return piece;
        }
        return null;
    }

    public static class Stairs
    extends MineshaftPiece {
        public Stairs() {
        }

        @Override
        protected void func_143012_a(@Nonnull NBTTagCompound compound) {
        }

        @Override
        protected void func_143011_b(@Nonnull NBTTagCompound compound, @Nonnull TemplateManager manager) {
        }

        public Stairs(int type, Random random, StructureBoundingBox box, EnumFacing facing, MapGenAtumMineshaft.Type mineshaftType) {
            super(type, mineshaftType);
            this.func_186164_a(facing);
            this.field_74887_e = box;
        }

        public static StructureBoundingBox findStairs(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox box = new StructureBoundingBox(x, y - 5, z, x, y + 2, z);
            switch (facing) {
                default: {
                    box.field_78893_d = x + 2;
                    box.field_78896_c = z - 8;
                    break;
                }
                case SOUTH: {
                    box.field_78893_d = x + 2;
                    box.field_78892_f = z + 8;
                    break;
                }
                case WEST: {
                    box.field_78897_a = x - 8;
                    box.field_78892_f = z + 2;
                    break;
                }
                case EAST: {
                    box.field_78893_d = x + 8;
                    box.field_78892_f = z + 2;
                }
            }
            return StructureComponent.func_74883_a(list, (StructureBoundingBox)box) != null ? null : box;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random random) {
            int i = this.func_74877_c();
            EnumFacing facing = this.func_186165_e();
            if (facing != null) {
                switch (facing) {
                    default: {
                        StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                        break;
                    }
                    case SOUTH: {
                        StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        break;
                    }
                    case WEST: {
                        StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                        break;
                    }
                    case EAST: {
                        StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                    }
                }
            }
        }

        public boolean func_74875_a(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_175804_a(world, box, 0, 5, 0, 2, 7, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(world, box, 0, 0, 7, 2, 2, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(world, box, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Room
    extends MineshaftPiece {
        private final List<StructureBoundingBox> connectedRooms = Lists.newLinkedList();

        public Room() {
        }

        public Room(int type, Random random, int x, int z, MapGenAtumMineshaft.Type mineshaftType) {
            super(type, mineshaftType);
            this.mineshaftType = mineshaftType;
            this.field_74887_e = new StructureBoundingBox(x, 50, z, x + 7 + random.nextInt(6), 54 + random.nextInt(6), z + 7 + random.nextInt(6));
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random random) {
            StructureBoundingBox box;
            MineshaftPiece piece;
            int k;
            int i = this.func_74877_c();
            int j = this.field_74887_e.func_78882_c() - 3 - 1;
            if (j <= 0) {
                j = 1;
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                piece = StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + random.nextInt(j) + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                if (piece == null) continue;
                box = piece.func_74874_b();
                this.connectedRooms.add(new StructureBoundingBox(box.field_78897_a, box.field_78895_b, this.field_74887_e.field_78896_c, box.field_78893_d, box.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (k = 0; k < this.field_74887_e.func_78883_b() && (k += random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); k += 4) {
                piece = StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + k, this.field_74887_e.field_78895_b + random.nextInt(j) + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                if (piece == null) continue;
                box = piece.func_74874_b();
                this.connectedRooms.add(new StructureBoundingBox(box.field_78897_a, box.field_78895_b, this.field_74887_e.field_78892_f - 1, box.field_78893_d, box.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                piece = StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + random.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, EnumFacing.WEST, i);
                if (piece == null) continue;
                box = piece.func_74874_b();
                this.connectedRooms.add(new StructureBoundingBox(this.field_74887_e.field_78897_a, box.field_78895_b, box.field_78896_c, this.field_74887_e.field_78897_a + 1, box.field_78894_e, box.field_78892_f));
            }
            for (k = 0; k < this.field_74887_e.func_78880_d() && (k += random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); k += 4) {
                MineshaftPiece structureComponent = StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + random.nextInt(j) + 1, this.field_74887_e.field_78896_c + k, EnumFacing.EAST, i);
                if (structureComponent == null) continue;
                StructureBoundingBox structureboundingbox3 = structureComponent.func_74874_b();
                this.connectedRooms.add(new StructureBoundingBox(this.field_74887_e.field_78893_d - 1, structureboundingbox3.field_78895_b, structureboundingbox3.field_78896_c, this.field_74887_e.field_78893_d, structureboundingbox3.field_78894_e, structureboundingbox3.field_78892_f));
            }
        }

        public boolean func_74875_a(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, AtumBlocks.SAND.func_176223_P(), Blocks.field_150350_a.func_176223_P(), true);
            this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (StructureBoundingBox connectedBox : this.connectedRooms) {
                this.func_175804_a(world, box, connectedBox.field_78897_a, connectedBox.field_78894_e - 2, connectedBox.field_78896_c, connectedBox.field_78893_d, connectedBox.field_78894_e, connectedBox.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_180777_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), false);
            return true;
        }

        public void func_181138_a(int x, int y, int z) {
            super.func_181138_a(x, y, z);
            for (StructureBoundingBox box : this.connectedRooms) {
                box.func_78886_a(x, y, z);
            }
        }

        @Override
        protected void func_143012_a(@Nonnull NBTTagCompound compound) {
            NBTTagList tagList = new NBTTagList();
            for (StructureBoundingBox box : this.connectedRooms) {
                tagList.func_74742_a((NBTBase)box.func_151535_h());
            }
            compound.func_74782_a("Entrances", (NBTBase)tagList);
        }

        @Override
        protected void func_143011_b(@Nonnull NBTTagCompound compound, @Nonnull TemplateManager manager) {
            NBTTagList tagList = compound.func_150295_c("Entrances", 11);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.connectedRooms.add(new StructureBoundingBox(tagList.func_150306_c(i)));
            }
        }
    }

    static abstract class MineshaftPiece
    extends StructureComponent {
        MapGenAtumMineshaft.Type mineshaftType;

        MineshaftPiece() {
        }

        MineshaftPiece(int type, MapGenAtumMineshaft.Type mineshaftType) {
            super(type);
            this.mineshaftType = mineshaftType;
        }

        protected void func_143012_a(@Nonnull NBTTagCompound compound) {
            compound.func_74768_a("MST", this.mineshaftType.ordinal());
        }

        protected void func_143011_b(@Nonnull NBTTagCompound compound, @Nonnull TemplateManager manager) {
            this.mineshaftType = MapGenAtumMineshaft.Type.byOrdinal(compound.func_74762_e("MST"));
        }

        IBlockState getSupportBlock() {
            if (this.mineshaftType == null) {
                this.mineshaftType = MapGenAtumMineshaft.Type.DEADWOOD;
            }
            switch (this.mineshaftType) {
                default: {
                    return BlockAtumPlank.getPlank(BlockAtumPlank.WoodType.DEADWOOD).func_176223_P();
                }
                case LIMESTONE: 
            }
            return BlockLimestoneBricks.getBrick(BlockLimestoneBricks.BrickType.LARGE).func_176223_P();
        }

        IBlockState getPillarBlock() {
            switch (this.mineshaftType) {
                default: {
                    return AtumBlocks.DEADWOOD_FENCE.func_176223_P();
                }
                case LIMESTONE: 
            }
            return BlockLimestoneWall.getWall(BlockLimestoneBricks.BrickType.LARGE).func_176223_P();
        }

        boolean isSupportingBox(World world, StructureBoundingBox boundingBox, int xMin, int x, int y, int z) {
            for (int i = xMin; i <= x; ++i) {
                if (this.func_175807_a(world, i, y + 1, z, boundingBox).func_185904_a() != Material.field_151579_a) continue;
                return false;
            }
            return true;
        }
    }

    public static class Cross
    extends MineshaftPiece {
        private EnumFacing corridorDirection;
        private boolean isMultipleFloors;

        public Cross() {
        }

        @Override
        protected void func_143012_a(@Nonnull NBTTagCompound compound) {
            compound.func_74757_a("tf", this.isMultipleFloors);
            compound.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        @Override
        protected void func_143011_b(@Nonnull NBTTagCompound compound, @Nonnull TemplateManager manager) {
            this.isMultipleFloors = compound.func_74767_n("tf");
            this.corridorDirection = EnumFacing.func_176731_b((int)compound.func_74762_e("D"));
        }

        public Cross(int type, Random random, StructureBoundingBox box, @Nullable EnumFacing facing, MapGenAtumMineshaft.Type mineshaftType) {
            super(type, mineshaftType);
            this.corridorDirection = facing;
            this.field_74887_e = box;
            this.isMultipleFloors = box.func_78882_c() > 3;
        }

        public static StructureBoundingBox findCrossing(List<StructureComponent> list, Random random, int x, int y, int z, EnumFacing facing) {
            StructureBoundingBox box = new StructureBoundingBox(x, y, z, x, y + 2, z);
            if (random.nextInt(4) == 0) {
                box.field_78894_e += 4;
            }
            switch (facing) {
                default: {
                    box.field_78897_a = x - 1;
                    box.field_78893_d = x + 3;
                    box.field_78896_c = z - 4;
                    break;
                }
                case SOUTH: {
                    box.field_78897_a = x - 1;
                    box.field_78893_d = x + 3;
                    box.field_78892_f = z + 3 + 1;
                    break;
                }
                case WEST: {
                    box.field_78897_a = x - 4;
                    box.field_78896_c = z - 1;
                    box.field_78892_f = z + 3;
                    break;
                }
                case EAST: {
                    box.field_78893_d = x + 3 + 1;
                    box.field_78896_c = z - 1;
                    box.field_78892_f = z + 3;
                }
            }
            return StructureComponent.func_74883_a(list, (StructureBoundingBox)box) != null ? null : box;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random random) {
            int type = this.func_74877_c();
            switch (this.corridorDirection) {
                default: {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, type);
                    break;
                }
                case SOUTH: {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, type);
                    break;
                }
                case WEST: {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, type);
                    break;
                }
                case EAST: {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, type);
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, type);
                }
            }
            if (this.isMultipleFloors) {
                if (random.nextBoolean()) {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, type);
                }
                if (random.nextBoolean()) {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, type);
                }
                if (random.nextBoolean()) {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, type);
                }
                if (random.nextBoolean()) {
                    StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, type);
                }
            }
        }

        public boolean func_74875_a(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            IBlockState plankState = this.getSupportBlock();
            if (this.isMultipleFloors) {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(world, box, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78894_e);
            this.placeSupportPillar(world, box, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78894_e);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_175807_a(world, i, this.field_74887_e.field_78895_b - 1, j, box).func_185904_a() != Material.field_151579_a || this.func_189916_b(world, i, this.field_74887_e.field_78895_b - 1, j, box) >= 8) continue;
                    this.func_175811_a(world, plankState, i, this.field_74887_e.field_78895_b - 1, j, box);
                }
            }
            return true;
        }

        private void placeSupportPillar(World world, StructureBoundingBox box, int x, int y, int z, int yMax) {
            if (this.func_175807_a(world, x, yMax + 1, z, box).func_185904_a() != Material.field_151579_a) {
                this.func_175804_a(world, box, x, y, z, x, yMax, z, this.getSupportBlock(), Blocks.field_150350_a.func_176223_P(), false);
            }
        }
    }

    public static class Corridor
    extends MineshaftPiece {
        private boolean hasRails;
        private boolean hasTarantula;
        private boolean spawnerPlaced;
        private int sectionCount;

        public Corridor() {
        }

        @Override
        protected void func_143012_a(@Nonnull NBTTagCompound compound) {
            compound.func_74757_a("hr", this.hasRails);
            compound.func_74757_a("sc", this.hasTarantula);
            compound.func_74757_a("hps", this.spawnerPlaced);
            compound.func_74768_a("Num", this.sectionCount);
        }

        @Override
        protected void func_143011_b(@Nonnull NBTTagCompound compound, @Nonnull TemplateManager manager) {
            this.hasRails = compound.func_74767_n("hr");
            this.hasTarantula = compound.func_74767_n("sc");
            this.spawnerPlaced = compound.func_74767_n("hps");
            this.sectionCount = compound.func_74762_e("Num");
        }

        Corridor(int type, Random random, StructureBoundingBox box, EnumFacing facing, MapGenAtumMineshaft.Type mineshaftType) {
            super(type, mineshaftType);
            this.func_186164_a(facing);
            this.field_74887_e = box;
            this.hasRails = random.nextInt(3) == 0;
            this.hasTarantula = !this.hasRails && random.nextInt(23) == 0;
            this.sectionCount = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? box.func_78880_d() / 5 : box.func_78883_b() / 5;
        }

        static StructureBoundingBox findCorridorSize(List<StructureComponent> components, Random random, int x, int y, int z, EnumFacing facing) {
            int i;
            StructureBoundingBox box = new StructureBoundingBox(x, y, z, x, y + 2, z);
            for (i = random.nextInt(3) + 2; i > 0; --i) {
                int j = i * 5;
                switch (facing) {
                    default: {
                        box.field_78893_d = x + 2;
                        box.field_78896_c = z - (j - 1);
                        break;
                    }
                    case SOUTH: {
                        box.field_78893_d = x + 2;
                        box.field_78892_f = z + (j - 1);
                        break;
                    }
                    case WEST: {
                        box.field_78897_a = x - (j - 1);
                        box.field_78892_f = z + 2;
                        break;
                    }
                    case EAST: {
                        box.field_78893_d = x + (j - 1);
                        box.field_78892_f = z + 2;
                    }
                }
                if (StructureComponent.func_74883_a(components, (StructureBoundingBox)box) == null) break;
            }
            return i > 0 ? box : null;
        }

        public void func_74861_a(StructureComponent component, List<StructureComponent> list, Random random) {
            block24: {
                int i = this.func_74877_c();
                int j = random.nextInt(4);
                EnumFacing facing = this.func_186165_e();
                if (facing != null) {
                    switch (facing) {
                        default: {
                            if (j <= 1) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, facing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                                break;
                            }
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                            break;
                        }
                        case SOUTH: {
                            if (j <= 1) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, facing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.WEST, i);
                                break;
                            }
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.EAST, i);
                            break;
                        }
                        case WEST: {
                            if (j <= 1) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, facing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                                break;
                            }
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                            break;
                        }
                        case EAST: {
                            if (j <= 1) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c, facing, i);
                                break;
                            }
                            if (j == 2) {
                                StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                                break;
                            }
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + random.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        }
                    }
                }
                if (i >= 8) break block24;
                if (facing != EnumFacing.NORTH && facing != EnumFacing.SOUTH) {
                    int count = this.field_74887_e.field_78897_a + 3;
                    while (count + 3 <= this.field_74887_e.field_78893_d) {
                        int j1 = random.nextInt(5);
                        if (j1 == 0) {
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, count, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i + 1);
                        } else if (j1 == 1) {
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, count, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i + 1);
                        }
                        count += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = random.nextInt(5);
                        if (l == 0) {
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, EnumFacing.WEST, i + 1);
                        } else if (l == 1) {
                            StructureAtumMineshaftPieces.generateAndAddPiece(component, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, EnumFacing.EAST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(@Nonnull World world, @Nonnull StructureBoundingBox box, @Nonnull Random random, int x, int y, int z, @Nonnull ResourceLocation loot) {
            BlockPos pos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (box.func_175898_b((Vec3i)pos) && world.func_180495_p(pos).func_185904_a() == Material.field_151579_a && world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                IBlockState railState = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)(random.nextBoolean() ? BlockRailBase.EnumRailDirection.NORTH_SOUTH : BlockRailBase.EnumRailDirection.EAST_WEST));
                this.func_175811_a(world, railState, x, y, z, box);
                EntityMinecartChest cartChest = new EntityMinecartChest(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
                cartChest.func_184289_a(loot, random.nextLong());
                world.func_72838_d((Entity)cartChest);
                return true;
            }
            return false;
        }

        public boolean func_74875_a(@Nonnull World world, @Nonnull Random random, @Nonnull StructureBoundingBox box) {
            if (this.func_74860_a(world, box)) {
                return false;
            }
            int count = this.sectionCount * 5 - 1;
            IBlockState iblockstate = this.getSupportBlock();
            this.func_175804_a(world, box, 0, 0, 0, 2, 1, count, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_189914_a(world, box, random, 0.8f, 0, 2, 0, 2, 2, count, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false, 0);
            for (int j1 = 0; j1 < this.sectionCount; ++j1) {
                int k2;
                int k1 = 2 + j1 * 5;
                this.placeSupport(world, box, 0, 0, k1, 2, 2, random);
                if (random.nextInt(100) == 0) {
                    this.func_186167_a(world, box, random, 2, 0, k1 - 1, AtumLootTables.CRATE);
                }
                if (random.nextInt(100) == 0) {
                    this.func_186167_a(world, box, random, 0, 0, k1 + 1, AtumLootTables.CRATE);
                }
                if (!this.hasTarantula || this.spawnerPlaced) continue;
                int l1 = this.func_74862_a(0);
                int i2 = k1 - 1 + random.nextInt(3);
                int j2 = this.func_74865_a(1, i2);
                BlockPos pos = new BlockPos(j2, l1, k2 = this.func_74873_b(1, i2));
                if (!box.func_175898_b((Vec3i)pos) || this.func_189916_b(world, 1, 0, i2, box) >= 8) continue;
                this.spawnerPlaced = true;
                world.func_180501_a(pos, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileEntity = world.func_175625_s(pos);
                if (!(tileEntity instanceof TileEntityMobSpawner)) continue;
                MapGenAtumMineshaft.Type type = this.mineshaftType;
                int chance = random.nextInt(100);
                if (chance < 40) {
                    if (type == MapGenAtumMineshaft.Type.DEADWOOD) {
                        ((TileEntityMobSpawner)tileEntity).func_145881_a().func_190894_a(AtumEntities.FORSAKEN.getRegistryName());
                        continue;
                    }
                    if (type != MapGenAtumMineshaft.Type.LIMESTONE) continue;
                    ((TileEntityMobSpawner)tileEntity).func_145881_a().func_190894_a(AtumEntities.STONEGUARD.getRegistryName());
                    continue;
                }
                ((TileEntityMobSpawner)tileEntity).func_145881_a().func_190894_a(AtumEntities.TARANTULA.getRegistryName());
            }
            for (int l2 = 0; l2 <= 2; ++l2) {
                for (int i3 = 0; i3 <= count; ++i3) {
                    IBlockState state = this.func_175807_a(world, l2, -1, i3, box);
                    if (state.func_185904_a() != Material.field_151579_a || this.func_189916_b(world, l2, -1, i3, box) >= 8) continue;
                    this.func_175811_a(world, iblockstate, l2, -1, i3, box);
                }
            }
            if (this.hasRails) {
                IBlockState railState = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                for (int j3 = 0; j3 <= count; ++j3) {
                    IBlockState state = this.func_175807_a(world, 1, -1, j3, box);
                    if (state.func_185904_a() == Material.field_151579_a || !state.func_185913_b()) continue;
                    float f = this.func_189916_b(world, 1, 0, j3, box) > 8 ? 0.9f : 0.7f;
                    this.func_175809_a(world, box, random, f, 1, 0, j3, railState);
                }
            }
            return true;
        }

        private void placeSupport(World world, StructureBoundingBox box, int x, int y, int z, int yMax, int xMin, Random random) {
            if (this.isSupportingBox(world, box, x, xMin, yMax, z)) {
                IBlockState plankState = this.getSupportBlock();
                IBlockState fenceState = this.getPillarBlock();
                IBlockState airState = Blocks.field_150350_a.func_176223_P();
                this.func_175804_a(world, box, x, y, z, x, yMax - 1, z, fenceState, airState, false);
                this.func_175804_a(world, box, xMin, y, z, xMin, yMax - 1, z, fenceState, airState, false);
                if (random.nextInt(4) == 0) {
                    this.func_175804_a(world, box, x, yMax, z, x, yMax, z, plankState, airState, false);
                    this.func_175804_a(world, box, xMin, yMax, z, xMin, yMax, z, plankState, airState, false);
                } else {
                    this.func_175804_a(world, box, x, yMax, z, xMin, yMax, z, plankState, airState, false);
                    if (this.mineshaftType == MapGenAtumMineshaft.Type.DEADWOOD) {
                        this.func_175809_a(world, box, random, 0.05f, x + 1, yMax, z - 1, BlockAtumTorchUnlit.getUnlitTorch((Block)AtumBlocks.DEADWOOD_TORCH).func_176223_P().func_177226_a((IProperty)BlockAtumTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
                        this.func_175809_a(world, box, random, 0.05f, x + 1, yMax, z + 1, BlockAtumTorchUnlit.getUnlitTorch((Block)AtumBlocks.DEADWOOD_TORCH).func_176223_P().func_177226_a((IProperty)BlockAtumTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
                    } else {
                        this.func_175809_a(world, box, random, 0.05f, x + 1, yMax, z - 1, BlockAtumTorchUnlit.getUnlitTorch((Block)AtumBlocks.LIMESTONE_TORCH).func_176223_P().func_177226_a((IProperty)BlockAtumTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
                        this.func_175809_a(world, box, random, 0.05f, x + 1, yMax, z + 1, BlockAtumTorchUnlit.getUnlitTorch((Block)AtumBlocks.LIMESTONE_TORCH).func_176223_P().func_177226_a((IProperty)BlockAtumTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
                    }
                }
            }
        }
    }
}

