/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.atum.world.gen.structure.ruins;

import com.teammetallurgy.atum.init.AtumBiomes;
import com.teammetallurgy.atum.init.AtumBlocks;
import com.teammetallurgy.atum.world.ChunkGeneratorAtum;
import com.teammetallurgy.atum.world.gen.structure.ruins.RuinPieces;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenRuin
extends MapGenStructure {
    private static final List<Biome> ALLOWED_BIOMES = Arrays.asList(new Biome[]{AtumBiomes.DEADWOOD_FOREST, AtumBiomes.LIMESTONE_MOUNTAINS, AtumBiomes.SAND_DUNES, AtumBiomes.SAND_HILLS, AtumBiomes.SAND_PLAINS});
    private final ChunkGeneratorAtum chunkGenerator;
    private int seed = 10387777;
    private int spacing = 5;
    private int separation = 3;

    public MapGenRuin(ChunkGeneratorAtum chunkGenerator) {
        this.chunkGenerator = chunkGenerator;
    }

    @Nonnull
    public String func_143025_a() {
        return String.valueOf(RuinPieces.RUIN);
    }

    public BlockPos func_180706_b(@Nonnull World world, @Nonnull BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = world;
        return MapGenRuin.func_191069_a((World)world, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)this.seed, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int x = chunkX;
        int z = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.spacing - 1;
        }
        int xSpacing = chunkX / this.spacing;
        int zSpacing = chunkZ / this.spacing;
        Random random = this.field_75039_c.func_72843_D(xSpacing, zSpacing, this.seed);
        xSpacing *= this.spacing;
        zSpacing *= this.spacing;
        if (x == (xSpacing += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2) && z == (zSpacing += (random.nextInt(this.spacing - this.separation) + random.nextInt(this.spacing - this.separation)) / 2)) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dz = -2; dz <= 2; ++dz) {
                    if (!this.chunkGenerator.pyramidGenerator.isPyramidInChunk(chunkX + dx, chunkZ + dz)) continue;
                    return false;
                }
            }
            return this.field_75039_c.func_72959_q().func_76940_a(x * 16 + 8, z * 16 + 8, 16, ALLOWED_BIOMES);
        }
        return false;
    }

    @Nonnull
    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.chunkGenerator, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        private boolean isValid;

        public Start() {
        }

        Start(World world, ChunkGeneratorAtum chunkGenerator, Random random, int x, int z) {
            super(x, z);
            this.create(world, chunkGenerator, random, x, z);
        }

        private void create(World world, ChunkGeneratorAtum chunkGenerator, Random random, int chunkX, int chunkZ) {
            Rotation rotation = Rotation.values()[random.nextInt(Rotation.values().length)];
            ChunkPrimer chunkPrimer = new ChunkPrimer();
            chunkGenerator.setBlocksInChunk(chunkX, chunkZ, chunkPrimer);
            int x = 5;
            int z = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                x = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                x = -5;
                z = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                z = -5;
            }
            int ground = chunkPrimer.func_186138_a(7, 7);
            int groundZ = chunkPrimer.func_186138_a(7, 7 + z);
            int groundX = chunkPrimer.func_186138_a(7 + x, 7);
            int groundXZ = chunkPrimer.func_186138_a(7 + x, 7 + z);
            int y = Math.min(Math.min(ground, groundZ), Math.min(groundX, groundXZ));
            if (y < 61 || y > 85) {
                this.isValid = false;
            } else {
                BlockPos pos = new BlockPos(chunkX * 16 + 8, y - 1, chunkZ * 16 + 8);
                RuinPieces.RuinTemplate ruin = new RuinPieces.RuinTemplate(world.func_72860_G().func_186340_h(), pos, random, rotation);
                this.field_75075_a.add(ruin);
                this.func_75072_c();
                this.isValid = true;
            }
        }

        public void func_75068_a(@Nonnull World world, @Nonnull Random rand, @Nonnull StructureBoundingBox box) {
            super.func_75068_a(world, rand, box);
            int y = this.field_75074_b.field_78895_b;
            for (int x = box.field_78897_a; x <= box.field_78893_d; ++x) {
                for (int z = box.field_78896_c; z <= box.field_78892_f; ++z) {
                    BlockPos ruinPos;
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.func_175623_d(pos) || !this.field_75074_b.func_175898_b((Vec3i)pos)) continue;
                    boolean isVecInside = false;
                    for (StructureComponent component : this.field_75075_a) {
                        if (!component.func_74874_b().func_175898_b((Vec3i)pos)) continue;
                        component.func_74875_a(world, rand, box);
                        isVecInside = true;
                        break;
                    }
                    if (!isVecInside) continue;
                    for (int ruinY = y - 1; ruinY > 1 && (world.func_175623_d(ruinPos = new BlockPos(x, ruinY, z)) || world.func_180495_p(ruinPos).func_185904_a().func_76224_d()); --ruinY) {
                        world.func_180501_a(ruinPos, AtumBlocks.LIMESTONE.func_176223_P(), 2);
                    }
                }
            }
        }

        public boolean func_75069_d() {
            return this.isValid;
        }
    }
}

